/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.net;

import com.aoindustries.net.HttpParameters;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public final class HttpParametersUtils {
    public static String addParams(String href, HttpParameters params, String encoding) throws UnsupportedEncodingException {
        if (params != null) {
            boolean hasQuestion;
            String anchor;
            StringBuilder sb = new StringBuilder(href);
            int anchorStart = href.lastIndexOf(35);
            if (anchorStart == -1) {
                anchor = null;
                hasQuestion = href.lastIndexOf(63) != -1;
            } else {
                anchor = href.substring(anchorStart);
                sb.setLength(anchorStart);
                hasQuestion = href.lastIndexOf(63, anchorStart - 1) != -1;
            }
            for (Map.Entry<String, List<String>> entry : params.getParameterMap().entrySet()) {
                String encodedName = URLEncoder.encode(entry.getKey(), encoding);
                for (String value : entry.getValue()) {
                    if (hasQuestion) {
                        sb.append('&');
                    } else {
                        sb.append('?');
                        hasQuestion = true;
                    }
                    sb.append(encodedName);
                    assert (value != null) : "null values no longer supported to be consistent with servlet environment";
                    sb.append('=').append(URLEncoder.encode(value, encoding));
                }
            }
            if (anchor != null) {
                sb.append(anchor);
            }
            href = sb.toString();
        }
        return href;
    }

    private HttpParametersUtils() {
    }
}

