/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.md5;

import com.aoindustries.util.StringUtility;

public class MD5 {
    private MD5State state;
    private MD5State finals;
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public final synchronized void Init() {
        this.state = new MD5State();
        this.finals = null;
    }

    public MD5() {
        this.Init();
    }

    public MD5(Object ob) {
        this();
        this.Update(ob.toString());
    }

    private static int rotate_left(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private static int FF(int a, int b, int c, int d, int x, int s, int ac) {
        a = a + (b & c | ~b & d) + x + ac;
        return MD5.rotate_left(a, s) + b;
    }

    private static int GG(int a, int b, int c, int d, int x, int s, int ac) {
        a = a + (b & d | c & ~d) + x + ac;
        return MD5.rotate_left(a, s) + b;
    }

    private static int HH(int a, int b, int c, int d, int x, int s, int ac) {
        a = a + (b ^ c ^ d) + x + ac;
        return MD5.rotate_left(a, s) + b;
    }

    private static int II(int a, int b, int c, int d, int x, int s, int ac) {
        a = a + (c ^ (b | ~d)) + x + ac;
        return MD5.rotate_left(a, s) + b;
    }

    private static int[] Decode(byte[] buffer, int len, int shift) {
        int[] out = new int[16];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            out[i] = buffer[j + shift] & 0xFF | (buffer[j + 1 + shift] & 0xFF) << 8 | (buffer[j + 2 + shift] & 0xFF) << 16 | (buffer[j + 3 + shift] & 0xFF) << 24;
            ++i;
        }
        return out;
    }

    private static void Transform(MD5State state, byte[] buffer, int shift) {
        int a = state.state[0];
        int b = state.state[1];
        int c = state.state[2];
        int d = state.state[3];
        int[] x = MD5.Decode(buffer, 64, shift);
        a = MD5.FF(a, b, c, d, x[0], 7, -680876936);
        d = MD5.FF(d, a, b, c, x[1], 12, -389564586);
        c = MD5.FF(c, d, a, b, x[2], 17, 606105819);
        b = MD5.FF(b, c, d, a, x[3], 22, -1044525330);
        a = MD5.FF(a, b, c, d, x[4], 7, -176418897);
        d = MD5.FF(d, a, b, c, x[5], 12, 1200080426);
        c = MD5.FF(c, d, a, b, x[6], 17, -1473231341);
        b = MD5.FF(b, c, d, a, x[7], 22, -45705983);
        a = MD5.FF(a, b, c, d, x[8], 7, 1770035416);
        d = MD5.FF(d, a, b, c, x[9], 12, -1958414417);
        c = MD5.FF(c, d, a, b, x[10], 17, -42063);
        b = MD5.FF(b, c, d, a, x[11], 22, -1990404162);
        a = MD5.FF(a, b, c, d, x[12], 7, 1804603682);
        d = MD5.FF(d, a, b, c, x[13], 12, -40341101);
        c = MD5.FF(c, d, a, b, x[14], 17, -1502002290);
        b = MD5.FF(b, c, d, a, x[15], 22, 1236535329);
        a = MD5.GG(a, b, c, d, x[1], 5, -165796510);
        d = MD5.GG(d, a, b, c, x[6], 9, -1069501632);
        c = MD5.GG(c, d, a, b, x[11], 14, 643717713);
        b = MD5.GG(b, c, d, a, x[0], 20, -373897302);
        a = MD5.GG(a, b, c, d, x[5], 5, -701558691);
        d = MD5.GG(d, a, b, c, x[10], 9, 38016083);
        c = MD5.GG(c, d, a, b, x[15], 14, -660478335);
        b = MD5.GG(b, c, d, a, x[4], 20, -405537848);
        a = MD5.GG(a, b, c, d, x[9], 5, 568446438);
        d = MD5.GG(d, a, b, c, x[14], 9, -1019803690);
        c = MD5.GG(c, d, a, b, x[3], 14, -187363961);
        b = MD5.GG(b, c, d, a, x[8], 20, 1163531501);
        a = MD5.GG(a, b, c, d, x[13], 5, -1444681467);
        d = MD5.GG(d, a, b, c, x[2], 9, -51403784);
        c = MD5.GG(c, d, a, b, x[7], 14, 1735328473);
        b = MD5.GG(b, c, d, a, x[12], 20, -1926607734);
        a = MD5.HH(a, b, c, d, x[5], 4, -378558);
        d = MD5.HH(d, a, b, c, x[8], 11, -2022574463);
        c = MD5.HH(c, d, a, b, x[11], 16, 1839030562);
        b = MD5.HH(b, c, d, a, x[14], 23, -35309556);
        a = MD5.HH(a, b, c, d, x[1], 4, -1530992060);
        d = MD5.HH(d, a, b, c, x[4], 11, 1272893353);
        c = MD5.HH(c, d, a, b, x[7], 16, -155497632);
        b = MD5.HH(b, c, d, a, x[10], 23, -1094730640);
        a = MD5.HH(a, b, c, d, x[13], 4, 681279174);
        d = MD5.HH(d, a, b, c, x[0], 11, -358537222);
        c = MD5.HH(c, d, a, b, x[3], 16, -722521979);
        b = MD5.HH(b, c, d, a, x[6], 23, 76029189);
        a = MD5.HH(a, b, c, d, x[9], 4, -640364487);
        d = MD5.HH(d, a, b, c, x[12], 11, -421815835);
        c = MD5.HH(c, d, a, b, x[15], 16, 530742520);
        b = MD5.HH(b, c, d, a, x[2], 23, -995338651);
        a = MD5.II(a, b, c, d, x[0], 6, -198630844);
        d = MD5.II(d, a, b, c, x[7], 10, 1126891415);
        c = MD5.II(c, d, a, b, x[14], 15, -1416354905);
        b = MD5.II(b, c, d, a, x[5], 21, -57434055);
        a = MD5.II(a, b, c, d, x[12], 6, 1700485571);
        d = MD5.II(d, a, b, c, x[3], 10, -1894986606);
        c = MD5.II(c, d, a, b, x[10], 15, -1051523);
        b = MD5.II(b, c, d, a, x[1], 21, -2054922799);
        a = MD5.II(a, b, c, d, x[8], 6, 1873313359);
        d = MD5.II(d, a, b, c, x[15], 10, -30611744);
        c = MD5.II(c, d, a, b, x[6], 15, -1560198380);
        b = MD5.II(b, c, d, a, x[13], 21, 1309151649);
        a = MD5.II(a, b, c, d, x[4], 6, -145523070);
        d = MD5.II(d, a, b, c, x[11], 10, -1120210379);
        c = MD5.II(c, d, a, b, x[2], 15, 718787259);
        b = MD5.II(b, c, d, a, x[9], 21, -343485551);
        state.state[0] = state.state[0] + a;
        state.state[1] = state.state[1] + b;
        state.state[2] = state.state[2] + c;
        state.state[3] = state.state[3] + d;
    }

    private void Update(MD5State stat, byte[] buffer, int offset, int length) {
        int i;
        this.finals = null;
        if (length - offset > buffer.length) {
            length = buffer.length - offset;
        }
        int index = stat.count[0] >>> 3 & 0x3F;
        stat.count[0] = stat.count[0] + (length << 3);
        if (stat.count[0] < length << 3) {
            stat.count[1] = stat.count[1] + 1;
        }
        stat.count[1] = stat.count[1] + (length >>> 29);
        int partlen = 64 - index;
        if (length >= partlen) {
            for (i = 0; i < partlen; ++i) {
                stat.buffer[i + index] = buffer[i + offset];
            }
            MD5.Transform(stat, stat.buffer, 0);
            i = partlen;
            while (i + 63 < length) {
                MD5.Transform(stat, buffer, i);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        if (i < length) {
            int start = i;
            while (i < length) {
                stat.buffer[index + i - start] = buffer[i + offset];
                ++i;
            }
        }
    }

    public void Update(byte[] buffer, int offset, int length) {
        this.Update(this.state, buffer, offset, length);
    }

    public void Update(byte[] buffer, int length) {
        this.Update(this.state, buffer, 0, length);
    }

    public void Update(byte[] buffer) {
        this.Update(buffer, 0, buffer.length);
    }

    public void Update(byte b) {
        byte[] buffer = new byte[]{b};
        this.Update(buffer, 1);
    }

    public final void Update(String s) {
        byte[] chars = s.getBytes();
        this.Update(chars, chars.length);
    }

    public void Update(int i) {
        this.Update((byte)(i & 0xFF));
    }

    private byte[] Encode(int[] input, int len) {
        byte[] out = new byte[len];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            out[j] = (byte)(input[i] & 0xFF);
            out[j + 1] = (byte)(input[i] >>> 8 & 0xFF);
            out[j + 2] = (byte)(input[i] >>> 16 & 0xFF);
            out[j + 3] = (byte)(input[i] >>> 24 & 0xFF);
            ++i;
        }
        return out;
    }

    public synchronized byte[] Final() {
        if (this.finals == null) {
            MD5State fin = new MD5State(this.state);
            byte[] bits = this.Encode(fin.count, 8);
            int index = fin.count[0] >>> 3 & 0x3F;
            int padlen = index < 56 ? 56 - index : 120 - index;
            this.Update(fin, padding, 0, padlen);
            this.Update(fin, bits, 0, 8);
            this.finals = fin;
        }
        return this.Encode(this.finals.state, 16);
    }

    public static String asHex(byte[] hash) {
        StringBuilder buf = new StringBuilder(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public String asHex() {
        return MD5.asHex(this.Final());
    }

    public static String getMD5String(long md5_hi, long md5_lo) {
        return new StringBuilder(32).append(hexChars[(int)(md5_hi >>> 60) & 0xF]).append(hexChars[(int)(md5_hi >>> 56) & 0xF]).append(hexChars[(int)(md5_hi >>> 52) & 0xF]).append(hexChars[(int)(md5_hi >>> 48) & 0xF]).append(hexChars[(int)(md5_hi >>> 44) & 0xF]).append(hexChars[(int)(md5_hi >>> 40) & 0xF]).append(hexChars[(int)(md5_hi >>> 36) & 0xF]).append(hexChars[(int)(md5_hi >>> 32) & 0xF]).append(hexChars[(int)(md5_hi >>> 28) & 0xF]).append(hexChars[(int)(md5_hi >>> 24) & 0xF]).append(hexChars[(int)(md5_hi >>> 20) & 0xF]).append(hexChars[(int)(md5_hi >>> 16) & 0xF]).append(hexChars[(int)(md5_hi >>> 12) & 0xF]).append(hexChars[(int)(md5_hi >>> 8) & 0xF]).append(hexChars[(int)(md5_hi >>> 4) & 0xF]).append(hexChars[(int)md5_hi & 0xF]).append(hexChars[(int)(md5_lo >>> 60) & 0xF]).append(hexChars[(int)(md5_lo >>> 56) & 0xF]).append(hexChars[(int)(md5_lo >>> 52) & 0xF]).append(hexChars[(int)(md5_lo >>> 48) & 0xF]).append(hexChars[(int)(md5_lo >>> 44) & 0xF]).append(hexChars[(int)(md5_lo >>> 40) & 0xF]).append(hexChars[(int)(md5_lo >>> 36) & 0xF]).append(hexChars[(int)(md5_lo >>> 32) & 0xF]).append(hexChars[(int)(md5_lo >>> 28) & 0xF]).append(hexChars[(int)(md5_lo >>> 24) & 0xF]).append(hexChars[(int)(md5_lo >>> 20) & 0xF]).append(hexChars[(int)(md5_lo >>> 16) & 0xF]).append(hexChars[(int)(md5_lo >>> 12) & 0xF]).append(hexChars[(int)(md5_lo >>> 8) & 0xF]).append(hexChars[(int)(md5_lo >>> 4) & 0xF]).append(hexChars[(int)md5_lo & 0xF]).toString();
    }

    public static long getMD5Hi(byte[] md5) {
        return (long)(md5[0] & 0xFF) << 56 | (long)(md5[1] & 0xFF) << 48 | (long)(md5[2] & 0xFF) << 40 | (long)(md5[3] & 0xFF) << 32 | (long)(md5[4] & 0xFF) << 24 | (long)(md5[5] & 0xFF) << 16 | (long)(md5[6] & 0xFF) << 8 | (long)(md5[7] & 0xFF);
    }

    private static long getHexValue(char ch) throws IllegalArgumentException {
        return StringUtility.getHex(ch);
    }

    public static long getMD5Hi(String md5) throws IllegalArgumentException {
        if (md5.length() != 32) {
            throw new IllegalArgumentException("MD5 sum is not 32 characters long, length is " + md5.length());
        }
        return MD5.getHexValue(md5.charAt(0)) << 60 | MD5.getHexValue(md5.charAt(1)) << 56 | MD5.getHexValue(md5.charAt(2)) << 52 | MD5.getHexValue(md5.charAt(3)) << 48 | MD5.getHexValue(md5.charAt(4)) << 44 | MD5.getHexValue(md5.charAt(5)) << 40 | MD5.getHexValue(md5.charAt(6)) << 36 | MD5.getHexValue(md5.charAt(7)) << 32 | MD5.getHexValue(md5.charAt(8)) << 28 | MD5.getHexValue(md5.charAt(9)) << 24 | MD5.getHexValue(md5.charAt(10)) << 20 | MD5.getHexValue(md5.charAt(11)) << 16 | MD5.getHexValue(md5.charAt(12)) << 12 | MD5.getHexValue(md5.charAt(13)) << 8 | MD5.getHexValue(md5.charAt(14)) << 4 | MD5.getHexValue(md5.charAt(15));
    }

    public static long getMD5Lo(byte[] md5) {
        return (long)(md5[8] & 0xFF) << 56 | (long)(md5[9] & 0xFF) << 48 | (long)(md5[10] & 0xFF) << 40 | (long)(md5[11] & 0xFF) << 32 | (long)(md5[12] & 0xFF) << 24 | (long)(md5[13] & 0xFF) << 16 | (long)(md5[14] & 0xFF) << 8 | (long)(md5[15] & 0xFF);
    }

    public static long getMD5Lo(String md5) throws IllegalArgumentException {
        if (md5.length() != 32) {
            throw new IllegalArgumentException("MD5 sum is not 32 characters long, length is " + md5.length());
        }
        return MD5.getHexValue(md5.charAt(16)) << 60 | MD5.getHexValue(md5.charAt(17)) << 56 | MD5.getHexValue(md5.charAt(18)) << 52 | MD5.getHexValue(md5.charAt(19)) << 48 | MD5.getHexValue(md5.charAt(20)) << 44 | MD5.getHexValue(md5.charAt(21)) << 40 | MD5.getHexValue(md5.charAt(22)) << 36 | MD5.getHexValue(md5.charAt(23)) << 32 | MD5.getHexValue(md5.charAt(24)) << 28 | MD5.getHexValue(md5.charAt(25)) << 24 | MD5.getHexValue(md5.charAt(26)) << 20 | MD5.getHexValue(md5.charAt(27)) << 16 | MD5.getHexValue(md5.charAt(28)) << 12 | MD5.getHexValue(md5.charAt(29)) << 8 | MD5.getHexValue(md5.charAt(30)) << 4 | MD5.getHexValue(md5.charAt(31));
    }

    static class MD5State {
        final int[] state;
        final int[] count;
        final byte[] buffer = new byte[64];

        MD5State() {
            this.count = new int[2];
            this.state = new int[4];
            this.state[0] = 1732584193;
            this.state[1] = -271733879;
            this.state[2] = -1732584194;
            this.state[3] = 271733878;
            this.count[1] = 0;
            this.count[0] = 0;
        }

        MD5State(MD5State from) {
            this();
            int i;
            for (i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = from.buffer[i];
            }
            for (i = 0; i < this.state.length; ++i) {
                this.state[i] = from.state[i];
            }
            for (i = 0; i < this.count.length; ++i) {
                this.count[i] = from.count[i];
            }
        }
    }
}

