/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.math;

public class SafeMath {
    private SafeMath() {
    }

    public static byte castByte(int value) throws ArithmeticException {
        if (value < -128) {
            throw new ArithmeticException("byte underflow: " + value);
        }
        if (value > 127) {
            throw new ArithmeticException("byte overflow: " + value);
        }
        return (byte)value;
    }

    public static byte castByte(long value) throws ArithmeticException {
        if (value < -128L) {
            throw new ArithmeticException("byte underflow: " + value);
        }
        if (value > 127L) {
            throw new ArithmeticException("byte overflow: " + value);
        }
        return (byte)value;
    }

    public static short castShort(int value) throws ArithmeticException {
        if (value < Short.MIN_VALUE) {
            throw new ArithmeticException("short underflow: " + value);
        }
        if (value > Short.MAX_VALUE) {
            throw new ArithmeticException("short overflow: " + value);
        }
        return (short)value;
    }

    public static int castInt(long value) throws ArithmeticException {
        if (value < Integer.MIN_VALUE) {
            throw new ArithmeticException("int underflow: " + value);
        }
        if (value > Integer.MAX_VALUE) {
            throw new ArithmeticException("int overflow: " + value);
        }
        return (int)value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long multiply(long value1, long value2) {
        if (value1 > value2) {
            long t = value1;
            value1 = value2;
            value2 = t;
        }
        if (value1 < 0L) {
            if (value2 < 0L) {
                if (value1 <= Long.MAX_VALUE / value2) return value1 * value2;
                throw new ArithmeticException("long*long overflow");
            }
            if (value2 <= 0L) return 0L;
            if (value1 >= Long.MIN_VALUE / value2) return value1 * value2;
            throw new ArithmeticException("long*long overflow");
        }
        if (value1 <= 0L) return 0L;
        if (value1 <= Long.MAX_VALUE / value2) return value1 * value2;
        throw new ArithmeticException("long*long overflow");
    }

    public static int avg(int value1, int value2) {
        return (int)(((long)value1 + (long)value2) / 2L);
    }
}

