/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.math;

import com.aoindustries.util.persistent.PersistentCollections;
import java.math.BigInteger;
import java.util.Arrays;

public class LongLong
extends Number
implements Comparable<LongLong> {
    public static final LongLong MIN_VALUE = LongLong.valueOf(Long.MIN_VALUE, 0L);
    public static final LongLong MAX_VALUE = LongLong.valueOf(Long.MAX_VALUE, -1L);
    private static final long serialVersionUID = -8296704159343817686L;
    private final long hi;
    private final long lo;
    public static final int SIZE = 128;

    private static byte[] getBytes(BigInteger bigInteger) {
        if (bigInteger.bitLength() > 127) {
            throw new NumberFormatException("For input string: \"" + bigInteger.toString() + "\"");
        }
        byte[] bytes = bigInteger.toByteArray();
        int diff = 16 - bytes.length;
        if (diff < 0) {
            throw new NumberFormatException("For input string: \"" + bigInteger.toString() + "\"");
        }
        if (diff > 0) {
            byte[] newBytes = new byte[16];
            if ((bytes[0] & 0x80) != 0) {
                Arrays.fill(newBytes, 0, diff, (byte)-1);
            }
            System.arraycopy(bytes, 0, newBytes, diff, bytes.length);
            bytes = newBytes;
        }
        return bytes;
    }

    private static byte[] parseLongLongToBytes(String s, int radix) throws NumberFormatException {
        return LongLong.getBytes(new BigInteger(s, radix));
    }

    public static LongLong parseLongLong(String s, int radix) throws NumberFormatException {
        byte[] bytes = LongLong.parseLongLongToBytes(s, radix);
        return LongLong.valueOf(PersistentCollections.bufferToLong(bytes), PersistentCollections.bufferToLong(bytes, 8));
    }

    public static LongLong parseLongLong(String s) throws NumberFormatException {
        return LongLong.parseLongLong(s, 10);
    }

    public static LongLong valueOf(String s, int radix) throws NumberFormatException {
        return LongLong.parseLongLong(s, radix);
    }

    public static LongLong valueOf(String s) throws NumberFormatException {
        return LongLong.parseLongLong(s, 10);
    }

    public static LongLong valueOf(long hi, long lo) {
        int offset = 128;
        if (hi == -1L && lo >= -128L && lo < 0L || hi == 0L && lo <= 127L && lo >= 0L) {
            return LongLongCache.cache[(int)lo + 128];
        }
        return new LongLong(hi, lo);
    }

    public LongLong(long hi, long lo) {
        this.hi = hi;
        this.lo = lo;
    }

    public LongLong(String s) throws NumberFormatException {
        byte[] bytes = LongLong.parseLongLongToBytes(s, 10);
        this.hi = PersistentCollections.bufferToLong(bytes);
        this.lo = PersistentCollections.bufferToLong(bytes, 8);
    }

    @Override
    public byte byteValue() {
        return (byte)this.lo;
    }

    @Override
    public short shortValue() {
        return (short)this.lo;
    }

    @Override
    public int intValue() {
        return (int)this.lo;
    }

    @Override
    public long longValue() {
        return this.lo;
    }

    private BigInteger getBigInteger() {
        byte[] bytes = new byte[16];
        PersistentCollections.longToBuffer(this.hi, bytes);
        PersistentCollections.longToBuffer(this.lo, bytes, 8);
        return new BigInteger(bytes);
    }

    @Override
    public float floatValue() {
        return this.getBigInteger().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.getBigInteger().doubleValue();
    }

    public String toString() {
        return this.getBigInteger().toString();
    }

    public int hashCode() {
        return (int)(this.hi ^ this.hi >>> 32) ^ (int)(this.lo ^ this.lo >>> 32);
    }

    public boolean equals(Object O) {
        if (O instanceof LongLong) {
            LongLong other = (LongLong)O;
            return this.hi == other.hi && this.lo == other.lo;
        }
        return false;
    }

    public static int compareUnsigned(long value1, long value2) {
        long i1 = value1 >>> 32;
        long i2 = value2 >>> 32;
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        i1 = value1 & 0xFFFFFFFFL;
        i2 = value2 & 0xFFFFFFFFL;
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(LongLong other) {
        if (this.hi < other.hi) {
            return -1;
        }
        if (this.hi > other.hi) {
            return 1;
        }
        return LongLong.compareUnsigned(this.lo, other.lo);
    }

    public int compareToUnsigned(LongLong other) {
        int diff = LongLong.compareUnsigned(this.hi, other.hi);
        if (diff != 0) {
            return diff;
        }
        return LongLong.compareUnsigned(this.lo, other.lo);
    }

    public LongLong highestOneBit() {
        long newHi = Long.highestOneBit(this.hi);
        long newLo = newHi != 0L ? 0L : Long.highestOneBit(this.lo);
        if (newHi == this.hi && newLo == this.lo) {
            return this;
        }
        return LongLong.valueOf(newHi, newLo);
    }

    public LongLong lowestOneBit() {
        long newLo = Long.lowestOneBit(this.lo);
        long newHi = newLo != 0L ? 0L : Long.lowestOneBit(this.hi);
        if (newHi == this.hi && newLo == this.lo) {
            return this;
        }
        return LongLong.valueOf(newHi, newLo);
    }

    public int numberOfLeadingZeros() {
        int leading = Long.numberOfLeadingZeros(this.hi);
        if (leading == 64) {
            leading += Long.numberOfLeadingZeros(this.lo);
        }
        return leading;
    }

    public int numberOfTrailingZeros() {
        int trailing = Long.numberOfTrailingZeros(this.lo);
        if (trailing == 64) {
            trailing += Long.numberOfTrailingZeros(this.hi);
        }
        return trailing;
    }

    public int bitCount() {
        return Long.bitCount(this.hi) + Long.bitCount(this.lo);
    }

    public LongLong rotateLeft(int distance) {
        long newLo;
        long newHi;
        if ((distance & 0x7F) == 0) {
            return this;
        }
        if ((distance & 0x3F) == 0) {
            newHi = this.lo;
            newLo = this.hi;
        } else {
            newHi = this.hi << distance | this.lo >>> -distance;
            newLo = this.lo << distance | this.hi >>> -distance;
        }
        if (newHi == this.hi && newLo == this.lo) {
            return this;
        }
        return LongLong.valueOf(newHi, newLo);
    }

    public LongLong rotateRight(int distance) {
        long newLo;
        long newHi;
        if ((distance & 0x7F) == 0) {
            return this;
        }
        if ((distance & 0x3F) == 0) {
            newHi = this.lo;
            newLo = this.hi;
        } else {
            newHi = this.hi >>> distance | this.lo << -distance;
            newLo = this.lo >>> distance | this.hi << -distance;
        }
        if (newHi == this.hi && newLo == this.lo) {
            return this;
        }
        return LongLong.valueOf(newHi, newLo);
    }

    public LongLong reverse() {
        long newHi = Long.reverse(this.lo);
        long newLo = Long.reverse(this.hi);
        if (newHi == this.hi && newLo == this.lo) {
            return this;
        }
        return LongLong.valueOf(newHi, newLo);
    }

    public int signum() {
        return Long.signum(this.hi);
    }

    public LongLong reverseBytes() {
        long newHi = Long.reverseBytes(this.lo);
        long newLo = Long.reverseBytes(this.hi);
        if (newHi == this.hi && newLo == this.lo) {
            return this;
        }
        return LongLong.valueOf(newHi, newLo);
    }

    public LongLong negate() {
        byte[] bytes = LongLong.getBytes(this.getBigInteger().negate());
        return LongLong.valueOf(PersistentCollections.bufferToLong(bytes), PersistentCollections.bufferToLong(bytes, 8));
    }

    public long getHigh() {
        return this.hi;
    }

    public long getLow() {
        return this.lo;
    }

    private static class LongLongCache {
        static final LongLong[] cache = new LongLong[256];

        private LongLongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                int value = i - 128;
                LongLongCache.cache[i] = new LongLong(value < 0 ? -1L : 0L, value);
            }
        }
    }
}

