/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.lang;

import com.aoindustries.util.BufferManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.charset.Charset;

public class ProcessResult {
    private final int exitVal;
    private final String stdout;
    private final String stderr;

    public static ProcessResult exec(String[] command) throws IOException {
        return ProcessResult.getProcessResult(Runtime.getRuntime().exec(command), Charset.defaultCharset());
    }

    public static ProcessResult exec(String[] command, Charset charset) throws IOException {
        return ProcessResult.getProcessResult(Runtime.getRuntime().exec(command), charset);
    }

    public static ProcessResult getProcessResult(Process process) throws IOException {
        return ProcessResult.getProcessResult(process, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResult getProcessResult(final Process process, final Charset charset) throws IOException {
        process.getOutputStream().close();
        final StringBuilder stdout = new StringBuilder();
        final IOException[] stdoutException = new IOException[1];
        Thread stdoutThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    InputStreamReader stdoutIn = new InputStreamReader(process.getInputStream(), charset);
                    try {
                        char[] buff = BufferManager.getChars();
                        try {
                            int count;
                            while ((count = ((Reader)stdoutIn).read(buff, 0, 4096)) != -1) {
                                StringBuilder stringBuilder = stdout;
                                synchronized (stringBuilder) {
                                    stdout.append(buff, 0, count);
                                }
                            }
                            return;
                        }
                        finally {
                            BufferManager.release(buff, false);
                        }
                    }
                    finally {
                        ((Reader)stdoutIn).close();
                    }
                }
                catch (IOException exc) {
                    IOException[] iOExceptionArray = stdoutException;
                    synchronized (stdoutException) {
                        stdoutException[0] = exc;
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
        stdoutThread.start();
        final StringBuilder stderr = new StringBuilder();
        final IOException[] stderrException = new IOException[1];
        Thread stderrThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    InputStreamReader stderrIn = new InputStreamReader(process.getErrorStream(), charset);
                    try {
                        char[] buff = BufferManager.getChars();
                        try {
                            int count;
                            while ((count = ((Reader)stderrIn).read(buff, 0, 4096)) != -1) {
                                StringBuilder stringBuilder = stderr;
                                synchronized (stringBuilder) {
                                    stderr.append(buff, 0, count);
                                }
                            }
                            return;
                        }
                        finally {
                            BufferManager.release(buff, false);
                        }
                    }
                    finally {
                        ((Reader)stderrIn).close();
                    }
                }
                catch (IOException exc) {
                    IOException[] iOExceptionArray = stderrException;
                    synchronized (stderrException) {
                        stderrException[0] = exc;
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
        stderrThread.start();
        try {
            stdoutThread.join();
            stderrThread.join();
            int exitVal = process.waitFor();
            IOException[] iOExceptionArray = stdoutException;
            synchronized (stdoutException) {
                if (stdoutException[0] != null) {
                    throw stdoutException[0];
                }
                // ** MonitorExit[var9_10] (shouldn't be in output)
                iOExceptionArray = stderrException;
                synchronized (stderrException) {
                    String stderrStr;
                    String stdoutStr;
                    if (stderrException[0] != null) {
                        throw stderrException[0];
                    }
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    StringBuilder stringBuilder = stdout;
                    synchronized (stringBuilder) {
                        stdoutStr = stdout.toString();
                    }
                    StringBuilder stringBuilder2 = stderr;
                    synchronized (stringBuilder2) {
                        stderrStr = stderr.toString();
                    }
                    return new ProcessResult(exitVal, stdoutStr, stderrStr);
                }
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            InterruptedIOException ioErr = new InterruptedIOException();
            ioErr.initCause(err);
            throw ioErr;
        }
    }

    private ProcessResult(int exitVal, String stdout, String stderr) {
        this.exitVal = exitVal;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public int getExitVal() {
        return this.exitVal;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }
}

