/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.TerminalWriter;
import com.aoindustries.sql.SQLUtility;
import com.aoindustries.util.StringUtility;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.BitSet;

public class ZeroFile {
    private static final boolean DEBUG = false;
    private static final boolean PROGRESS = true;
    private static final boolean DRY_RUN = false;
    private static final int BLOCK_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("usage: " + ZeroFile.class.getName() + " <mb_per_sec>[/<mb_per_sec_write>] <path>");
            System.exit(1);
        } else {
            try {
                int bpsIn;
                int bpsOut;
                String bpsArg = args[0];
                int slashPos = bpsArg.indexOf(47);
                if (slashPos == -1) {
                    bpsIn = bpsOut = Integer.parseInt(bpsArg);
                } else {
                    bpsIn = Integer.parseInt(bpsArg.substring(0, slashPos));
                    bpsOut = Integer.parseInt(bpsArg.substring(slashPos + 1));
                }
                File file = new File(args[1]);
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                try {
                    long bytesWritten = ZeroFile.zeroFile(bpsIn, bpsOut, raf);
                }
                finally {
                    raf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                System.exit(2);
            }
        }
    }

    private static long sleep(int bps, long lastTime) throws IOException {
        try {
            long millisPerBlock = 1000 / bps;
            long sleepUntil = lastTime + millisPerBlock;
            long currentTime = System.currentTimeMillis();
            long sleepyTime = sleepUntil - currentTime;
            if (sleepyTime <= 0L) {
                return currentTime;
            }
            if (sleepyTime > millisPerBlock) {
                Thread.sleep(millisPerBlock);
                return currentTime + millisPerBlock;
            }
            Thread.sleep(sleepyTime);
            return currentTime + sleepyTime;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException ioExc = new InterruptedIOException(e.getMessage());
            ioExc.initCause(e);
            throw ioExc;
        }
    }

    public static long zeroFile(int bpsIn, int bpsOut, RandomAccessFile raf) throws IOException {
        long len = raf.length();
        long blocksLong = len / 0x100000L;
        if ((len & 0xFFFFFL) != 0L) {
            ++blocksLong;
        }
        if (blocksLong > Integer.MAX_VALUE) {
            throw new IOException("File too large: " + len);
        }
        int blocks = (int)blocksLong;
        BitSet dirtyBlocks = new BitSet(blocks);
        int numDirtyBlocks = 0;
        long lastTime = System.currentTimeMillis();
        byte[] buff = new byte[0x100000];
        int blockIndex = 0;
        String lastVerboseString = "";
        int block = 0;
        long pos = 0L;
        while (pos < len) {
            long blockSizeLong = len - pos;
            int blockSize = blockSizeLong > 0x100000L ? 0x100000 : (int)blockSizeLong;
            raf.seek(pos);
            raf.readFully(buff, 0, blockSize);
            ++block;
            lastTime = ZeroFile.sleep(bpsIn, lastTime);
            boolean allZero = true;
            for (int i = 0; i < blockSize; ++i) {
                if (buff[i] == 0) continue;
                allZero = false;
                break;
            }
            if (!allZero) {
                dirtyBlocks.set(blockIndex);
                ++numDirtyBlocks;
            }
            lastVerboseString = TerminalWriter.progressOutput(lastVerboseString, StringUtility.getApproximateSize(pos + (long)blockSize) + ": " + SQLUtility.getDecimal((long)block * 10000L / (long)blocks) + "% read, " + SQLUtility.getDecimal((long)numDirtyBlocks * 10000L / (long)block) + "% dirty", System.err);
            pos += 0x100000L;
            ++blockIndex;
        }
        System.err.println();
        lastVerboseString = "";
        long bytesWritten = 0L;
        blockIndex = 0;
        Arrays.fill(buff, (byte)0);
        int written = 0;
        long pos2 = 0L;
        while (pos2 < len) {
            if (dirtyBlocks.get(blockIndex)) {
                long blockSizeLong = len - pos2;
                int blockSize = blockSizeLong > 0x100000L ? 0x100000 : (int)blockSizeLong;
                raf.seek(pos2);
                raf.write(buff, 0, blockSize);
                lastTime = ZeroFile.sleep(bpsOut, lastTime);
                lastVerboseString = TerminalWriter.progressOutput(lastVerboseString, StringUtility.getApproximateSize(bytesWritten += (long)blockSize) + ": " + SQLUtility.getDecimal((long)(++written) * 10000L / (long)numDirtyBlocks) + "% written", System.err);
            }
            pos2 += 0x100000L;
            ++blockIndex;
        }
        System.err.println();
        lastVerboseString = "";
        return bytesWritten;
    }
}

