/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FileUtils;
import java.io.File;
import java.io.IOException;

public class TempFile {
    private volatile File tempFile;
    private final String path;

    public TempFile(String prefix) throws IOException {
        this(prefix, null, null);
    }

    public TempFile(String prefix, String suffix) throws IOException {
        this(prefix, suffix, null);
    }

    public TempFile(String prefix, String suffix, File directory) throws IOException {
        File checkDir = directory;
        if (checkDir == null) {
            checkDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (!checkDir.exists()) {
            FileUtils.mkdirs(checkDir);
        }
        this.tempFile = File.createTempFile(prefix, suffix, directory);
        this.tempFile.deleteOnExit();
        this.path = this.tempFile.getPath();
    }

    public String toString() {
        return this.path;
    }

    public void delete() throws IOException {
        File f = this.tempFile;
        if (f != null) {
            FileUtils.delete(f);
            this.tempFile = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public File getFile() throws IllegalStateException {
        File f = this.tempFile;
        if (f == null) {
            throw new IllegalStateException();
        }
        return f;
    }
}

