/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private final StringBuilder buffer;

    public StringBuilderWriter() {
        this.buffer = new StringBuilder();
    }

    public StringBuilderWriter(int initialCapacity) {
        this.buffer = new StringBuilder(initialCapacity);
    }

    public StringBuilderWriter(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int c) {
        this.buffer.append((char)c);
    }

    @Override
    public void write(char[] cbuf) {
        this.buffer.append(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buffer.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buffer.append(str, off, off + len);
    }

    @Override
    public StringBuilderWriter append(CharSequence csq) {
        this.buffer.append(csq);
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public StringBuilderWriter append(char c) {
        this.buffer.append(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

