/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FileUtils;
import com.aoindustries.io.FilesystemIterator;
import com.aoindustries.io.FilesystemIteratorRule;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ParallelDelete {
    private static final int DELETE_QUEUE_SIZE = 5000;
    private static final int VERBOSE_QUEUE_SIZE = 1000;

    private ParallelDelete() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: " + ParallelDelete.class.getName() + " [-n] [-v] [--] path {path}");
            System.err.println("\t-n\tPerform dry run, do not modify the filesystem");
            System.err.println("\t-v\tWrite the full path to standard error as each file is removed");
            System.err.println("\t--\tEnd options, all additional arguments will be interpreted as paths");
            System.exit(1);
        } else {
            ArrayList<File> directories = new ArrayList<File>(args.length);
            PrintStream verboseOutput = null;
            boolean dryRun = false;
            boolean optionsEnded = false;
            for (String arg : args) {
                if (!optionsEnded && arg.equals("-v")) {
                    verboseOutput = System.err;
                    continue;
                }
                if (!optionsEnded && arg.equals("-n")) {
                    dryRun = true;
                    continue;
                }
                if (!optionsEnded && arg.equals("--")) {
                    optionsEnded = true;
                    continue;
                }
                directories.add(new File(arg));
            }
            try {
                ParallelDelete.parallelDelete(directories, verboseOutput, dryRun);
            }
            catch (IOException err) {
                err.printStackTrace(System.err);
                System.err.flush();
                System.exit(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void parallelDelete(List<File> directories, final PrintStream verboseOutput, boolean dryRun) throws IOException {
        numDirectories = directories.size();
        nextFiles = new TreeMap<String, ArrayList<FilesystemIterator>>(new Comparator<String>(){

            @Override
            public int compare(String S1, String S2) {
                int diff = S1.compareTo(S2);
                if (diff == 0) {
                    return 0;
                }
                if (S2.startsWith(S1)) {
                    return 1;
                }
                if (S1.startsWith(S2)) {
                    return -1;
                }
                return diff;
            }
        });
        prefixRules = Collections.emptyMap();
        for (File directory : directories) {
            if (!directory.exists()) {
                throw new IOException("Directory not found: " + directory.getPath());
            }
            if (!directory.isDirectory()) {
                throw new IOException("Not a directory: " + directory.getPath());
            }
            path = directory.getCanonicalPath();
            iterator = new FilesystemIterator(Collections.singletonMap(path, FilesystemIteratorRule.OK), prefixRules, path, false, true);
            nextFile = iterator.getNextFile();
            if (nextFile == null) continue;
            relPath = ParallelDelete.getRelativePath(nextFile, iterator);
            list = (ArrayList<FilesystemIterator>)nextFiles.get(relPath);
            if (list == null) {
                list = new ArrayList<FilesystemIterator>(numDirectories);
                nextFiles.put(relPath, list);
            }
            list.add(iterator);
        }
        if (verboseOutput == null) {
            verboseQueue = null;
            verboseThreadRun = null;
            verboseThread = null;
        } else {
            verboseQueue = new ArrayBlockingQueue<E>(1000);
            verboseThreadRun = new boolean[]{true};
            verboseThread = new Thread("ParallelDelete - Verbose Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    while (true) {
                        boolean[] blArray = verboseThreadRun;
                        // MONITORENTER : verboseThreadRun
                        if (!verboseThreadRun[0] && verboseQueue.isEmpty()) {
                            // MONITOREXIT : blArray
                            return;
                        }
                        // MONITOREXIT : blArray
                        try {
                            verboseOutput.println(((File)verboseQueue.take()).getPath());
                            if (!verboseQueue.isEmpty()) continue;
                            verboseOutput.flush();
                        }
                        catch (InterruptedException err) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                }
            };
            verboseThread.start();
        }
        try {
            deleteQueue = new ArrayBlockingQueue<E>(5000);
            deleteThreadRun = new boolean[]{true};
            deleteException = new IOException[1];
            deleteThread = new Thread("ParallelDelete - Delete Thread", (BlockingQueue)deleteQueue, deleteException, verboseQueue, dryRun){
                final /* synthetic */ BlockingQueue val$deleteQueue;
                final /* synthetic */ IOException[] val$deleteException;
                final /* synthetic */ BlockingQueue val$verboseQueue;
                final /* synthetic */ boolean val$dryRun;
                {
                    this.val$deleteQueue = blockingQueue;
                    this.val$deleteException = iOExceptionArray;
                    this.val$verboseQueue = blockingQueue2;
                    this.val$dryRun = bl;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    while (true) {
                        boolean[] blArray = deleteThreadRun;
                        // MONITORENTER : deleteThreadRun
                        if (!deleteThreadRun[0] && this.val$deleteQueue.isEmpty()) {
                            // MONITOREXIT : blArray
                            return;
                        }
                        // MONITOREXIT : blArray
                        try {
                            File deleteme = (File)this.val$deleteQueue.take();
                            IOException[] iOExceptionArray = this.val$deleteException;
                            // MONITORENTER : this.val$deleteException
                            boolean doDelete = this.val$deleteException[0] == null;
                            // MONITOREXIT : iOExceptionArray
                            if (!doDelete) continue;
                            try {
                                if (this.val$verboseQueue != null) {
                                    boolean done = false;
                                    while (!done) {
                                        try {
                                            this.val$verboseQueue.put(deleteme);
                                            done = true;
                                        }
                                        catch (InterruptedException err) {
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                }
                                if (this.val$dryRun) continue;
                                FileUtils.delete(deleteme);
                            }
                            catch (IOException err) {
                                IOException[] iOExceptionArray2 = this.val$deleteException;
                                // MONITORENTER : this.val$deleteException
                                this.val$deleteException[0] = err;
                                // MONITOREXIT : iOExceptionArray2
                            }
                            continue;
                        }
                        catch (InterruptedException err) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                }
            };
            deleteThread.start();
            try {
                SB = new StringBuilder();
                block29: while (true) {
                    var13_15 = deleteException;
                    // MONITORENTER : deleteException
                    if (deleteException[0] != null) {
                        // MONITOREXIT : var13_15
                        ** break;
                    }
                    // MONITOREXIT : var13_15
                    iter = nextFiles.keySet().iterator();
                    if (!iter.hasNext()) ** break;
                    relPath = (String)iter.next();
                    var15_17 = ((List)nextFiles.remove(relPath)).iterator();
                    while (true) {
                        if (!var15_17.hasNext()) continue block29;
                        iterator = (FilesystemIterator)var15_17.next();
                        SB.setLength(0);
                        SB.append(iterator.getStartPath());
                        SB.append(relPath);
                        fullPath = SB.toString();
                        try {
                            deleteQueue.put(new File(fullPath));
                        }
                        catch (InterruptedException err) {
                            Thread.currentThread().interrupt();
                            ioErr = new InterruptedIOException();
                            ioErr.initCause(err);
                            throw ioErr;
                        }
                        nextFile = iterator.getNextFile();
                        if (nextFile == null) continue;
                        newRelPath = ParallelDelete.getRelativePath(nextFile, iterator);
                        list = (ArrayList<FilesystemIterator>)nextFiles.get(newRelPath);
                        if (list == null) {
                            list = new ArrayList<FilesystemIterator>(numDirectories);
                            nextFiles.put(newRelPath, list);
                        }
                        list.add(iterator);
                    }
                    break;
                }
            }
            catch (Throwable var23_24) {
                var24_25 /* !! */  = deleteThreadRun;
                // MONITORENTER : deleteThreadRun
                deleteThreadRun[0] = false;
                // MONITOREXIT : var24_25 /* !! */ 
                deleteThread.interrupt();
                try {
                    deleteThread.join();
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    ioErr = new InterruptedIOException();
                    ioErr.initCause(err);
                    throw ioErr;
                }
                var24_25 /* !! */  = (boolean[])deleteException;
                // MONITORENTER : deleteException
                if (deleteException[0] != null) {
                    throw deleteException[0];
                }
                // MONITOREXIT : var24_25 /* !! */ 
                throw var23_24;
            }
lbl100:
            // 2 sources

            SB = deleteThreadRun;
            // MONITORENTER : deleteThreadRun
            deleteThreadRun[0] = false;
            // MONITOREXIT : SB
            deleteThread.interrupt();
            try {
                deleteThread.join();
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                ioErr = new InterruptedIOException();
                ioErr.initCause(err);
                throw ioErr;
            }
            var12_13 = deleteException;
            // MONITORENTER : deleteException
            if (deleteException[0] != null) {
                throw deleteException[0];
            }
            // MONITOREXIT : var12_13
            if (verboseThread == null) return;
        }
        catch (Throwable var28_28) {
            if (verboseThread == null) throw var28_28;
            var29_29 = verboseThreadRun;
            // MONITORENTER : verboseThreadRun
            verboseThreadRun[0] = false;
            // MONITOREXIT : var29_29
            verboseThread.interrupt();
            try {
                verboseThread.join();
                throw var28_28;
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                ioErr = new InterruptedIOException();
                ioErr.initCause(err);
                throw ioErr;
            }
        }
        deleteQueue = verboseThreadRun;
        // MONITORENTER : verboseThreadRun
        verboseThreadRun[0] = false;
        // MONITOREXIT : deleteQueue
        verboseThread.interrupt();
        try {
            verboseThread.join();
            return;
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            ioErr = new InterruptedIOException();
            ioErr.initCause(err);
            throw ioErr;
        }
    }

    private static String getRelativePath(File file, FilesystemIterator iterator) throws IOException {
        String prefix;
        String path = file.getPath();
        if (!path.startsWith(prefix = iterator.getStartPath())) {
            throw new IOException("path doesn't start with prefix: path=\"" + path + "\", prefix=\"" + prefix + "\"");
        }
        return path.substring(prefix.length());
    }
}

