/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.lang.NullArgumentException;
import com.aoindustries.util.BufferManager;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IoUtils {
    private IoUtils() {
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IoUtils.copy(in, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, boolean flush) throws IOException {
        byte[] buff = BufferManager.getBytes();
        try {
            int numBytes;
            long totalBytes = 0L;
            while ((numBytes = in.read(buff, 0, 4096)) != -1) {
                out.write(buff, 0, numBytes);
                if (flush) {
                    out.flush();
                }
                totalBytes += (long)numBytes;
            }
            long l = totalBytes;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, Writer out) throws IOException {
        char[] buff = BufferManager.getChars();
        try {
            int numChars;
            long totalChars = 0L;
            while ((numChars = in.read(buff, 0, 4096)) != -1) {
                out.write(buff, 0, numChars);
                totalChars += (long)numChars;
            }
            long l = totalChars;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, Appendable out) throws IOException {
        if (in == null) {
            throw new NullArgumentException("in");
        }
        if (out == null) {
            throw new NullArgumentException("out");
        }
        char[] buff = BufferManager.getChars();
        try {
            int numChars;
            long totalChars = 0L;
            while ((numChars = in.read(buff, 0, 4096)) != -1) {
                out.append(new String(buff, 0, numChars));
                totalChars += (long)numChars;
            }
            long l = totalChars;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, StringBuilder out) throws IOException {
        char[] buff = BufferManager.getChars();
        try {
            int numChars;
            long totalChars = 0L;
            while ((numChars = in.read(buff, 0, 4096)) != -1) {
                out.append(buff, 0, numChars);
                totalChars += (long)numChars;
            }
            long l = totalChars;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        IoUtils.readFully(in, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream in, byte[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            int count = in.read(buffer, off, len);
            if (count == -1) {
                throw new EOFException();
            }
            off += count;
            len -= count;
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IoUtils.copy(in, bout);
        return bout.toByteArray();
    }

    public static String readFully(Reader in) throws IOException {
        StringBuilder sb = new StringBuilder();
        IoUtils.copy(in, sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(InputStream in, byte[] contents) throws IOException {
        int contentLen = contents.length;
        byte[] buff = BufferManager.getBytes();
        try {
            int readPos = 0;
            while (readPos < contentLen) {
                int bytesRemaining = contentLen - readPos;
                int bytesRead = in.read(buff, 0, bytesRemaining > 4096 ? 4096 : bytesRemaining);
                if (bytesRead == -1) {
                    boolean bl = false;
                    return bl;
                }
                int i = 0;
                while (i < bytesRead) {
                    if (buff[i++] == contents[readPos++]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = in.read() == -1;
            return bl;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }
}

