/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.util.BufferManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FixedRecordFile
extends RandomAccessFile {
    private final int recordLength;
    private final byte[] buff1;
    private final byte[] buff2;

    public FixedRecordFile(String name, String mode, int recordLength) throws FileNotFoundException {
        super(name, mode);
        this.recordLength = recordLength;
        this.buff1 = new byte[recordLength];
        this.buff2 = new byte[recordLength];
    }

    public FixedRecordFile(File file, String mode, int recordLength) throws FileNotFoundException {
        super(file, mode);
        this.recordLength = recordLength;
        this.buff1 = new byte[recordLength];
        this.buff2 = new byte[recordLength];
    }

    public void seekToExistingRecord(int index) throws IndexOutOfBoundsException, IOException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + "<0");
        }
        long startPos = (long)index * (long)this.recordLength;
        if (startPos >= this.length()) {
            throw new IndexOutOfBoundsException(index + ">=" + this.getRecordCount());
        }
        this.seek(startPos);
    }

    public void addRecord(int index) throws IndexOutOfBoundsException, IOException {
        this.addRecords(index, 1);
    }

    public void addRecords(int index, int numRecords) throws IndexOutOfBoundsException, IOException {
        if (numRecords < 0) {
            throw new IllegalArgumentException("numRecords<0: " + numRecords);
        }
        if (numRecords > 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index<0: " + index);
            }
            long recordsStart = (long)index * (long)this.recordLength;
            long recordsBytes = (long)numRecords * (long)this.recordLength;
            long recordsEnd = recordsStart + recordsBytes;
            if (recordsStart >= this.length()) {
                this.setLength(recordsEnd);
            } else {
                long moveLength = this.length() - recordsStart;
                this.setLength(this.length() + recordsBytes);
                FixedRecordFile.copyBytes(this, recordsStart, this, recordsStart + recordsBytes, moveLength);
            }
            this.seek(recordsStart);
        }
    }

    public int getRecordCount() throws IOException {
        long size = this.length() / (long)this.recordLength;
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(RandomAccessFile from, long fromIndex, RandomAccessFile to, long toIndex, long numBytes) throws IOException {
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes<0: " + numBytes);
        }
        if (numBytes > 0L) {
            byte[] buff = BufferManager.getBytes();
            try {
                if (fromIndex < toIndex) {
                    long readLocation = fromIndex + numBytes;
                    while (readLocation > fromIndex) {
                        int bytesLeft;
                        long readEnd = readLocation;
                        if ((readLocation -= 4096L) < fromIndex) {
                            readLocation = fromIndex;
                        }
                        from.seek(readLocation);
                        int pos = 0;
                        while ((bytesLeft = (int)(readEnd - readLocation - (long)pos)) > 0) {
                            int ret = from.read(buff, pos, bytesLeft);
                            if (ret == -1) {
                                throw new EOFException();
                            }
                            pos += ret;
                        }
                        to.seek(toIndex + (readLocation - fromIndex));
                        to.write(buff, 0, pos);
                    }
                } else {
                    int ret;
                    for (long numCopied = 0L; numCopied < numBytes; numCopied += (long)ret) {
                        long blockSizeLong = numBytes - numCopied;
                        int blockSize = blockSizeLong > 4096L ? 4096 : (int)blockSizeLong;
                        from.seek(fromIndex + numCopied);
                        ret = from.read(buff, 0, blockSize);
                        if (ret == -1) {
                            throw new EOFException();
                        }
                        to.seek(toIndex + numCopied);
                        to.write(buff, 0, ret);
                    }
                }
            }
            finally {
                BufferManager.release(buff, false);
            }
        }
    }

    public static void copyRecords(FixedRecordFile from, long fromIndex, FixedRecordFile to, long toIndex, long numRecords) throws IOException {
        if (numRecords < 0L) {
            throw new IllegalArgumentException("numRecords<0: " + numRecords);
        }
        int recordLength = from.recordLength;
        if (recordLength != to.recordLength) {
            throw new IllegalArgumentException("Files do not have the same record length: from.recordLength=" + recordLength + ", to.recordLength=" + to.recordLength);
        }
        FixedRecordFile.copyBytes(from, fromIndex * (long)recordLength, to, toIndex * (long)recordLength, numRecords * (long)recordLength);
    }

    public void removeAllRecords() throws IOException {
        this.setLength(0L);
    }

    public void removeRecord(int index) throws IOException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + "<0");
        }
        long startPos = (long)index * (long)this.recordLength;
        if (startPos >= this.length()) {
            throw new IndexOutOfBoundsException(index + ">=" + this.getRecordCount());
        }
        long newEnd = this.length() - (long)this.recordLength;
        if (newEnd > startPos) {
            FixedRecordFile.copyBytes(this, startPos + (long)this.recordLength, this, startPos, newEnd - startPos);
        }
        this.setLength(newEnd);
    }

    public int getRecordLength() throws IOException {
        return this.recordLength;
    }

    public void swap(int index1, int index2) throws IOException {
        if (index1 != index2) {
            if (index1 < 0) {
                throw new IndexOutOfBoundsException("index1<0: " + index1);
            }
            long startPos1 = (long)index1 * (long)this.recordLength;
            if (startPos1 >= this.length()) {
                throw new IndexOutOfBoundsException("index1>=" + this.getRecordCount() + ": " + index1);
            }
            if (index2 < 0) {
                throw new IndexOutOfBoundsException("index2<0: " + index2);
            }
            long startPos2 = (long)index2 * (long)this.recordLength;
            if (startPos2 >= this.length()) {
                throw new IndexOutOfBoundsException("index2>=" + this.getRecordCount() + ": " + index2);
            }
            this.seek(startPos1);
            this.readFully(this.buff1);
            this.seek(startPos2);
            this.readFully(this.buff2);
            this.seek(startPos2);
            this.write(this.buff1);
            this.seek(startPos1);
            this.write(this.buff2);
        }
    }
}

