/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.IOException;
import java.io.Writer;

public class FindReplaceWriter
extends Writer {
    private final Writer out;
    private final char[] find;
    private final char[] replace;
    private int findMatched = 0;

    public FindReplaceWriter(Writer out, String find, String replace) {
        this(out, find.toCharArray(), replace.toCharArray());
    }

    public FindReplaceWriter(Writer out, char[] find, char[] replace) {
        this.out = out;
        this.find = find;
        this.replace = replace;
    }

    private void clearBuffer() throws IOException {
        if (this.findMatched > 0) {
            this.out.write(this.find, 0, this.findMatched);
            this.findMatched = 0;
        }
    }

    @Override
    public void write(int c) throws IOException {
        char ch = (char)c;
        if (ch == this.find[this.findMatched]) {
            ++this.findMatched;
            if (this.findMatched >= this.find.length) {
                if (this.replace.length > 0) {
                    this.out.write(this.replace);
                }
                this.findMatched = 0;
            }
        } else {
            this.clearBuffer();
            this.out.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            this.write(cbuf[off++]);
            --len;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        while (len > 0) {
            this.write(str.charAt(off++));
            --len;
        }
    }

    @Override
    public FindReplaceWriter append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.write("null");
        } else {
            this.append(csq, 0, csq.length());
        }
        return this;
    }

    @Override
    public FindReplaceWriter append(CharSequence csq, int start, int end) throws IOException {
        while (start < end) {
            this.write(csq.charAt(start++));
        }
        return this;
    }

    @Override
    public FindReplaceWriter append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.clearBuffer();
        this.out.close();
    }
}

