/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FindReplaceProxy {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");

    private FindReplaceProxy() {
    }

    public static void main(String[] args) {
        boolean showArgs = false;
        if ((args.length - 4) % 3 != 0) {
            showArgs = true;
        } else {
            try {
                int listenPort = Integer.parseInt(args[1]);
                int connectPort = Integer.parseInt(args[3]);
                ArrayList<FindReplace> inFindReplaces = new ArrayList<FindReplace>();
                ArrayList<FindReplace> outFindReplaces = new ArrayList<FindReplace>();
                for (int pos = 4; pos < args.length; pos += 3) {
                    String find = args[pos];
                    String replace = args[pos + 1];
                    String mode = args[pos + 2];
                    FindReplace findReplace = new FindReplace(find, replace);
                    if ("in".equals(mode)) {
                        inFindReplaces.add(findReplace);
                        continue;
                    }
                    if ("out".equals(mode)) {
                        outFindReplaces.add(findReplace);
                        continue;
                    }
                    if ("both".equals(mode)) {
                        inFindReplaces.add(findReplace);
                        outFindReplaces.add(findReplace);
                        continue;
                    }
                    showArgs = true;
                    break;
                }
                if (!showArgs) {
                    while (true) {
                        try {
                            InetAddress listenAddress = InetAddress.getByName(args[0]);
                            InetAddress connectAddress = InetAddress.getByName(args[2]);
                            ServerSocket ss = new ServerSocket(listenPort, 50, listenAddress);
                            try {
                                while (true) {
                                    Socket socketIn = ss.accept();
                                    new FindReplaceProxyThread(socketIn, listenAddress, connectAddress, connectPort, Collections.unmodifiableList(inFindReplaces), Collections.unmodifiableList(outFindReplaces)).start();
                                }
                            }
                            catch (Throwable throwable) {
                                ss.close();
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace(System.err);
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                System.err.println(e.toString());
                showArgs = true;
            }
        }
        if (showArgs) {
            System.err.println("Usage: " + FindReplaceProxy.class.getName() + "listen_address listen_port connect_address connect_port [find replace {in|out|both}]...");
            System.exit(1);
        }
    }

    static int indexOf(byte[] buff, int numBytes, byte[] findBytes, int pos) {
        int findLen = findBytes.length;
        if (findLen > 0) {
            while (pos + findLen < numBytes) {
                boolean found = true;
                for (int i = 0; i < findLen; ++i) {
                    if (buff[pos + i] == findBytes[i]) continue;
                    found = false;
                    break;
                }
                if (found) {
                    return pos;
                }
                ++pos;
            }
        }
        return -1;
    }

    static class FindReplaceReadThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;
        private final List<FindReplace> findReplaces;

        FindReplaceReadThread(InputStream in, OutputStream out, List<FindReplace> findReplaces) {
            this.in = in;
            this.out = out;
            this.findReplaces = findReplaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    try {
                        int numBytes;
                        byte[] buff = new byte[4096];
                        while ((numBytes = this.in.read(buff, 0, 4096)) != -1) {
                            int pos = 0;
                            while (pos < numBytes) {
                                int lowestIndex = -1;
                                FindReplace lowestFindReplace = null;
                                for (FindReplace findReplace : this.findReplaces) {
                                    int index = FindReplaceProxy.indexOf(buff, numBytes, findReplace.findBytes, pos);
                                    if (index == -1 || lowestIndex != -1 && index >= lowestIndex) continue;
                                    lowestIndex = index;
                                    lowestFindReplace = findReplace;
                                }
                                if (lowestIndex != -1) {
                                    assert (lowestFindReplace != null);
                                    this.out.write(buff, pos, lowestIndex - pos);
                                    this.out.write(lowestFindReplace.replaceBytes);
                                    pos = lowestIndex + lowestFindReplace.findBytes.length;
                                    continue;
                                }
                                this.out.write(buff, pos, numBytes - pos);
                                pos = numBytes;
                            }
                            this.out.flush();
                        }
                    }
                    finally {
                        this.out.close();
                    }
                }
                finally {
                    this.in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    static class FindReplaceProxyThread
    extends Thread {
        private final Socket socketIn;
        private final InetAddress sourceAddress;
        private final InetAddress connectAddress;
        private final int connectPort;
        private final List<FindReplace> inFindReplaces;
        private final List<FindReplace> outFindReplaces;

        FindReplaceProxyThread(Socket socketIn, InetAddress sourceAddress, InetAddress connectAddress, int connectPort, List<FindReplace> inFindReplaces, List<FindReplace> outFindReplaces) {
            this.socketIn = socketIn;
            this.sourceAddress = sourceAddress;
            this.connectAddress = connectAddress;
            this.connectPort = connectPort;
            this.inFindReplaces = inFindReplaces;
            this.outFindReplaces = outFindReplaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    Socket socketOut = new Socket(this.connectAddress, this.connectPort, this.sourceAddress, 0);
                    try {
                        FindReplaceReadThread inThread = new FindReplaceReadThread(this.socketIn.getInputStream(), socketOut.getOutputStream(), this.inFindReplaces);
                        try {
                            inThread.start();
                            FindReplaceReadThread outThread = new FindReplaceReadThread(socketOut.getInputStream(), this.socketIn.getOutputStream(), this.outFindReplaces);
                            try {
                                outThread.start();
                            }
                            finally {
                                try {
                                    inThread.join();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace(System.err);
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        finally {
                            try {
                                inThread.join();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace(System.err);
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    finally {
                        socketOut.close();
                    }
                }
                finally {
                    this.socketIn.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    static class FindReplace {
        private final String find;
        private final byte[] findBytes;
        private final String replace;
        private final byte[] replaceBytes;

        FindReplace(String find, String replace) {
            this.find = find;
            this.findBytes = find.getBytes(CHARSET);
            this.replace = replace;
            this.replaceBytes = replace.getBytes(CHARSET);
        }
    }
}

