/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.lang.ObjectUtils;
import com.aoindustries.math.SafeMath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ByteCount
implements Serializable,
Comparable<ByteCount> {
    private static final long serialVersionUID = 1712831669919116474L;
    private final long quantity;
    private final Unit unit;
    private transient long byteCount;

    private static long getByteCount(long quantity, Unit unit) {
        if (quantity < 1L) {
            throw new IllegalArgumentException("quantity<1");
        }
        return SafeMath.multiply(quantity, unit == null ? 1L : unit.getCoefficient());
    }

    public static ByteCount valueOf(String value) {
        return new ByteCount(value);
    }

    public ByteCount(long byteCount) {
        this(byteCount, null);
    }

    public ByteCount(long quantity, Unit unit) {
        this.quantity = quantity;
        this.unit = unit;
        this.byteCount = ByteCount.getByteCount(quantity, unit);
    }

    public ByteCount(String value) {
        Unit valueUnit = null;
        for (int c = Unit.values.length - 1; c >= 0; --c) {
            Unit u = Unit.values[c];
            String name = u.getName();
            if (!value.endsWith(name)) continue;
            valueUnit = u;
            value = value.substring(0, value.length() - name.length());
        }
        this.quantity = Long.parseLong(value);
        this.unit = valueUnit;
        this.byteCount = ByteCount.getByteCount(this.quantity, this.unit);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.byteCount = ByteCount.getByteCount(this.quantity, this.unit);
    }

    public boolean equals(Object O) {
        if (!(O instanceof ByteCount)) {
            return false;
        }
        ByteCount other = (ByteCount)O;
        return this.quantity == other.quantity && ObjectUtils.equals((Object)this.unit, (Object)other.unit);
    }

    public int hashCode() {
        return (int)(this.byteCount ^ this.byteCount >>> 32);
    }

    public String toString() {
        if (this.unit == null) {
            return Long.toString(this.quantity);
        }
        return Long.toString(this.quantity) + this.unit.getName();
    }

    @Override
    public int compareTo(ByteCount o) {
        return this.byteCount < o.byteCount ? -1 : (this.byteCount == o.byteCount ? 0 : 1);
    }

    public long getQuantity() {
        return this.quantity;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public static enum Unit {
        BYTE("byte", 1L),
        KBYTE("kbyte", 1000L),
        KIBYTE("Kibyte", 1024L),
        MBYTE("Mbyte", 1000000L),
        MIBYTE("Mibyte", 0x100000L),
        GBYTE("Gbyte", 1000000000L),
        GIBYTE("Gibyte", 0x40000000L),
        TBYTE("Tbyte", 1000000000000L),
        TIBYTE("Tibyte", 0x10000000000L),
        PBYTE("Pbyte", 1000000000000000L),
        PIBYTE("Pibyte", 0x4000000000000L),
        EBYTE("Ebyte", 1000000000000000000L),
        EIBYTE("Eibyte", 0x1000000000000000L);

        private static final Unit[] values;
        private final String name;
        private final long coefficient;

        private Unit(String name, long coefficient) {
            this.name = name;
            this.coefficient = coefficient;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public long getCoefficient() {
            return this.coefficient;
        }

        static {
            values = Unit.values();
        }
    }
}

