/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.BitRateProvider;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class BitRateOutputStream
extends FilterOutputStream {
    public static final long MAX_CATCHUP_TIME = 2000L;
    private final BitRateProvider provider;
    private long blockStart = -1L;
    private long catchupTime;
    private long byteCount;

    public BitRateOutputStream(OutputStream out, BitRateProvider provider) {
        super(out);
        this.provider = provider;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        this.out.write(b);
        ++this.byteCount;
        this.sleepIfNeeded();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        this.out.write(b, 0, b.length);
        this.byteCount += (long)b.length;
        this.sleepIfNeeded();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        this.out.write(b, off, len);
        this.byteCount += (long)len;
        this.sleepIfNeeded();
    }

    @Override
    public void flush() throws IOException {
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        this.out.flush();
        this.sleep();
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.blockStart = -1L;
        this.catchupTime = 0L;
        this.byteCount = 0L;
    }

    private void sleepIfNeeded() throws IOException {
        if (this.byteCount > (long)this.provider.getBlockSize()) {
            this.sleep();
        }
    }

    private void sleep() throws IOException {
        if (this.byteCount > 0L) {
            Long bps = this.provider.getBitRate();
            if (bps != null && bps > 0L) {
                long blockTime = this.byteCount * 8L * 1000L / bps;
                long sleepyTime = blockTime - (System.currentTimeMillis() - this.blockStart);
                if (sleepyTime > 0L) {
                    if (this.catchupTime > sleepyTime) {
                        this.catchupTime -= sleepyTime;
                    } else {
                        sleepyTime -= this.catchupTime;
                        this.catchupTime = 0L;
                        try {
                            Thread.sleep(sleepyTime);
                        }
                        catch (InterruptedException err) {
                            Thread.currentThread().interrupt();
                            InterruptedIOException ioErr = new InterruptedIOException();
                            ioErr.initCause(err);
                            throw ioErr;
                        }
                    }
                } else {
                    this.catchupTime -= sleepyTime;
                    if (this.catchupTime >= 2000L) {
                        this.catchupTime = 2000L;
                    }
                }
            } else {
                this.catchupTime = 0L;
            }
            this.blockStart = System.currentTimeMillis();
            this.byteCount = 0L;
        }
    }
}

