/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.BitRateProvider;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class BitRateInputStream
extends FilterInputStream {
    public static final long MAX_CATCHUP_TIME = 2000L;
    private final BitRateProvider provider;
    private long blockStart = -1L;
    private long catchupTime;
    private long byteCount;

    public BitRateInputStream(InputStream out, BitRateProvider provider) {
        super(out);
        this.provider = provider;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.sleep();
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        if ((b = this.in.read()) != -1) {
            ++this.byteCount;
        }
        this.sleepIfNeeded();
        return b;
    }

    @Override
    public int read(byte[] buff) throws IOException {
        int count;
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        if ((count = this.in.read(buff)) != -1) {
            this.byteCount += (long)count;
        }
        this.sleepIfNeeded();
        return count;
    }

    @Override
    public int read(byte[] buff, int off, int len) throws IOException {
        int count;
        if (this.blockStart == -1L) {
            this.blockStart = System.currentTimeMillis();
        }
        if ((count = this.in.read(buff, off, len)) != -1) {
            this.byteCount += (long)count;
        }
        this.sleepIfNeeded();
        return count;
    }

    private void sleepIfNeeded() throws IOException {
        if (this.byteCount > (long)this.provider.getBlockSize()) {
            this.sleep();
        }
    }

    private void sleep() throws IOException {
        if (this.byteCount > 0L) {
            Long bps = this.provider.getBitRate();
            if (bps != null && bps > 0L) {
                long blockTime = this.byteCount * 8L * 1000L / bps;
                long sleepyTime = blockTime - (System.currentTimeMillis() - this.blockStart);
                if (sleepyTime > 0L) {
                    if (this.catchupTime > sleepyTime) {
                        this.catchupTime -= sleepyTime;
                    } else {
                        sleepyTime -= this.catchupTime;
                        this.catchupTime = 0L;
                        try {
                            Thread.sleep(sleepyTime);
                        }
                        catch (InterruptedException err) {
                            Thread.currentThread().interrupt();
                            InterruptedIOException ioErr = new InterruptedIOException();
                            ioErr.initCause(err);
                            throw ioErr;
                        }
                    }
                } else {
                    this.catchupTime -= sleepyTime;
                    if (this.catchupTime >= 2000L) {
                        this.catchupTime = 2000L;
                    }
                }
            } else {
                this.catchupTime = 0L;
            }
            this.blockStart = System.currentTimeMillis();
            this.byteCount = 0L;
        }
    }
}

