/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.lang.ObjectUtils;
import com.aoindustries.math.SafeMath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BitRate
implements Serializable,
Comparable<BitRate> {
    private static final long serialVersionUID = -7706564767874892683L;
    private final long quantity;
    private final Unit unit;
    private transient Long bitRate;

    private static long getBitRate(long quantity, Unit unit) {
        if (quantity < 1L) {
            throw new IllegalArgumentException("quantity<1");
        }
        return SafeMath.multiply(quantity, unit == null ? 1L : unit.getCoefficient());
    }

    public static BitRate valueOf(String value) {
        return new BitRate(value);
    }

    public BitRate(long bitRate) {
        this(bitRate, null);
    }

    public BitRate(long quantity, Unit unit) {
        this.quantity = quantity;
        this.unit = unit;
        this.bitRate = BitRate.getBitRate(quantity, unit);
    }

    public BitRate(String value) {
        Unit valueUnit = null;
        for (int c = Unit.values.length - 1; c >= 0; --c) {
            Unit u = Unit.values[c];
            String name = u.getName();
            if (!value.endsWith(name)) continue;
            valueUnit = u;
            value = value.substring(0, value.length() - name.length());
        }
        this.quantity = Long.parseLong(value);
        this.unit = valueUnit;
        this.bitRate = BitRate.getBitRate(this.quantity, this.unit);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.bitRate = BitRate.getBitRate(this.quantity, this.unit);
    }

    public boolean equals(Object O) {
        if (!(O instanceof BitRate)) {
            return false;
        }
        BitRate other = (BitRate)O;
        return this.quantity == other.quantity && ObjectUtils.equals((Object)this.unit, (Object)other.unit);
    }

    public int hashCode() {
        return this.bitRate.hashCode();
    }

    public String toString() {
        if (this.unit == null) {
            return Long.toString(this.quantity);
        }
        return Long.toString(this.quantity) + this.unit.getName();
    }

    @Override
    public int compareTo(BitRate o) {
        return this.bitRate.compareTo(o.bitRate);
    }

    public long getQuantity() {
        return this.quantity;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Long getBitRate() {
        return this.bitRate;
    }

    public static enum Unit {
        BIT("bit", 1L),
        KBIT("kbit", 1000L),
        KIBIT("Kibit", 1024L),
        MBIT("Mbit", 1000000L),
        MIBIT("Mibit", 0x100000L),
        GBIT("Gbit", 1000000000L),
        GIBIT("Gibit", 0x40000000L),
        TBIT("Tbit", 1000000000000L),
        TIBIT("Tibit", 0x10000000000L),
        PBIT("Pbit", 1000000000000000L),
        PIBIT("Pibit", 0x4000000000000L),
        EBIT("Ebit", 1000000000000000000L),
        EIBIT("Eibit", 0x1000000000000000L),
        BYTE("byte", 8L),
        KBYTE("kbyte", 8000L),
        KIBYTE("Kibyte", 8192L),
        MBYTE("Mbyte", 8000000L),
        MIBYTE("Mibyte", 0x800000L),
        GBYTE("Gbyte", 8000000000L),
        GIBYTE("Gibyte", 0x200000000L),
        TBYTE("Tbyte", 8000000000000L),
        TIBYTE("Tibyte", 0x80000000000L),
        PBYTE("Pbyte", 8000000000000000L),
        PIBYTE("Pibyte", 0x20000000000000L),
        EBYTE("Ebyte", 8000000000000000000L),
        EIBYTE("Eibyte", Long.MIN_VALUE);

        private static final Unit[] values;
        private final String name;
        private final long coefficient;

        private Unit(String name, long coefficient) {
            this.name = name;
            this.coefficient = coefficient;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public long getCoefficient() {
            return this.coefficient;
        }

        static {
            values = Unit.values();
        }
    }
}

