/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.awt;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class OptimalIndexColorModel
extends IndexColorModel {
    private static final int DROP_THRESHOLD = 96;
    private static final int DROP_OFFSET = 1000;

    private OptimalIndexColorModel(int size, byte[] r, byte[] g, byte[] b, int trans) {
        super(8, size, r, g, b, trans);
    }

    public static OptimalIndexColorModel getOptimalIndexColorModel(BufferedImage image) {
        HashMap<Integer, ColorCount> colorCounts = new HashMap<Integer, ColorCount>();
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Integer color = image.getRGB(x, y);
                ColorCount colorCount = (ColorCount)colorCounts.get(color);
                if (colorCount == null) {
                    colorCount = new ColorCount(color);
                    colorCounts.put(color, colorCount);
                }
                ++colorCount.count;
            }
        }
        for (ColorCount colorCount : colorCounts.values()) {
            int color = colorCount.color;
            int brightness = Math.max(color >>> 16 & 0xFF, Math.max(color >>> 8 & 0xFF, color & 0xFF));
            if (brightness >= 96) continue;
            colorCount.count += 1000;
        }
        ArrayList colorCountList = new ArrayList(colorCounts.values());
        Collections.sort(colorCountList, ColorCountCountComparator.getInstance());
        int size = colorCountList.size();
        int numColorsUsed = size > 256 ? 256 : size;
        byte[] r = new byte[numColorsUsed];
        byte[] g = new byte[numColorsUsed];
        byte[] b = new byte[numColorsUsed];
        int transparent_index = -1;
        for (int c = 0; c < numColorsUsed; ++c) {
            int color = ((ColorCount)colorCountList.get((int)c)).color;
            r[c] = (byte)(color >>> 16 & 0xFF);
            g[c] = (byte)(color >>> 8 & 0xFF);
            b[c] = (byte)(color & 0xFF);
        }
        return new OptimalIndexColorModel(numColorsUsed, r, g, b, transparent_index);
    }

    static class ColorCountCountComparator
    implements Comparator<ColorCount> {
        private static final ColorCountCountComparator instance = new ColorCountCountComparator();

        static ColorCountCountComparator getInstance() {
            return instance;
        }

        private ColorCountCountComparator() {
        }

        @Override
        public int compare(ColorCount o1, ColorCount o2) {
            return o1.count - o2.count;
        }

        @Override
        public boolean equals(Object obj) {
            return obj != null && obj instanceof ColorCountCountComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    static class ColorCount {
        int color;
        int count;

        ColorCount(int color) {
            this.color = color;
        }

        public boolean equals(Object O) {
            return O != null && O instanceof ColorCount && ((ColorCount)O).color == this.color;
        }

        public int hashCode() {
            return this.color;
        }
    }
}

