/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class LabelledGridLayout
implements LayoutManager {
    public final int rows;
    public final int columns;
    public final int hgap;
    public final int vgap;
    public final int cgap;
    public final boolean stretchComponents;

    public LabelledGridLayout(int rows, int columns) {
        this(rows, columns, 0, 0, 0, true);
    }

    public LabelledGridLayout(int rows, int columns, int hgap, int vgap, int cgap) {
        this.rows = rows;
        this.columns = columns;
        this.hgap = hgap;
        this.vgap = vgap;
        this.cgap = cgap;
        this.stretchComponents = true;
    }

    public LabelledGridLayout(int rows, int columns, int hgap, int vgap, int cgap, boolean stretchComponents) {
        this.rows = rows;
        this.columns = columns;
        this.hgap = hgap;
        this.vgap = vgap;
        this.cgap = cgap;
        this.stretchComponents = stretchComponents;
    }

    @Override
    public void addLayoutComponent(String place, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent, boolean isMinimum) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int x;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.columns;
            if (nrows > 0) {
                ncols = (ncomponents / 2 + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents / 2 + ncols - 1) / ncols;
            }
            int[] widths = new int[ncols * 2];
            int totalHeight = 0;
            int highest = 0;
            int pos = 0;
            block3: for (int y = 0; y < nrows; ++y) {
                if (!this.stretchComponents) {
                    highest = 0;
                }
                for (x = 0; x < ncols * 2; ++x) {
                    Dimension d;
                    if (pos >= ncomponents) break block3;
                    Component component = parent.getComponent(pos++);
                    Dimension dimension = d = isMinimum ? component.getMinimumSize() : component.getPreferredSize();
                    if (d.width > widths[x]) {
                        widths[x] = d.width;
                    }
                    if (d.height <= highest) continue;
                    highest = d.height;
                }
                if (this.stretchComponents) continue;
                totalHeight += highest;
            }
            int widest = 0;
            for (x = 0; x < ncols; ++x) {
                int width = widths[x * 2] + widths[x * 2 + 1];
                if (width <= widest) continue;
                widest = width;
            }
            return new Dimension(insets.left + ncols * widest + insets.right + this.hgap * (this.columns - 1) + this.cgap * this.columns, insets.top + (this.stretchComponents ? nrows * highest : totalHeight) + insets.bottom + this.vgap * (this.rows - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            int nrows = this.rows;
            int ncols = this.columns;
            if (nrows > 0) {
                ncols = (ncomponents / 2 + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents / 2 + ncols - 1) / ncols;
            }
            int[] labelWidths = new int[ncols];
            int pos = 0;
            block3: for (int y = 0; y < nrows; ++y) {
                for (int x = 0; x < ncols; ++x) {
                    if (pos >= ncomponents) break block3;
                    Component component = parent.getComponent(pos);
                    pos += 2;
                    Dimension d = component.getPreferredSize();
                    if (d.width <= labelWidths[x]) continue;
                    labelWidths[x] = d.width;
                }
            }
            Dimension parentSize = parent.getSize();
            int width = parentSize.width - (insets.left + insets.right);
            int height = parentSize.height - (insets.top + insets.bottom);
            int lasty = 0;
            pos = 0;
            block5: for (int y = 0; y < nrows; ++y) {
                int yend = 0;
                int cellHeight = 0;
                if (this.stretchComponents) {
                    yend = (y + 1) * (height + this.vgap) / nrows - this.vgap;
                    cellHeight = yend - lasty;
                }
                int lastx = 0;
                for (int x = 0; x < ncols; ++x) {
                    int actualWidth;
                    if (pos >= ncomponents) break block5;
                    int availableWidth = labelWidths[x];
                    int xend = (x + 1) * (width + this.hgap) / ncols - this.hgap;
                    int cellWidth = xend - lastx;
                    if (availableWidth > cellWidth) {
                        availableWidth = cellWidth;
                    }
                    Component label = parent.getComponent(pos++);
                    Dimension labelD = label.getPreferredSize();
                    Component component = parent.getComponent(pos++);
                    Dimension componentD = component.getPreferredSize();
                    if (!this.stretchComponents && lasty + (cellHeight = Math.max(labelD.height, componentD.height)) > yend) {
                        yend = lasty + cellHeight;
                    }
                    label.setBounds(lastx + insets.left, lasty + insets.top, availableWidth, cellHeight);
                    if (pos > ncomponents) break block5;
                    availableWidth = cellWidth - this.cgap - labelWidths[x];
                    if (availableWidth < 0) {
                        availableWidth = 0;
                    }
                    if ((actualWidth = componentD.width) > availableWidth) {
                        actualWidth = availableWidth;
                    }
                    component.setBounds(lastx + labelWidths[x] + this.cgap + insets.left, lasty + insets.top, actualWidth, cellHeight);
                    lastx = xend + this.hgap;
                }
                lasty = yend + this.vgap;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

