/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.formatter;

import com.log.kit.formatter.LogFormatter;

public class StackTraceFormatter
implements LogFormatter<StackTraceElement[]> {
    @Override
    public String format(StackTraceElement[] stackTrace) {
        if (stackTrace == null || stackTrace.length == 0) {
            return null;
        }
        if (stackTrace.length == 1) {
            return "\t-" + stackTrace[0].toString();
        }
        StringBuilder sb = new StringBuilder();
        int len = stackTrace.length;
        for (int x = 0; x < len; ++x) {
            if (x == 0) {
                sb.append("stackTrace:  \n");
            }
            if (x == len - 1) {
                sb.append("\t\u2514 ");
                sb.append(stackTrace[x].toString());
                continue;
            }
            sb.append("\t\u251c ");
            sb.append(stackTrace[x].toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

