/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit;

import androidx.annotation.NonNull;
import com.log.kit.LogConfig;
import com.log.kit.print.LogPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LogKitManager {
    private LogConfig mConfig;
    private List<LogPrinter> mPrinters = new ArrayList<LogPrinter>();

    private LogKitManager() {
    }

    public static LogKitManager getInstance() {
        return SingleHolder.instance;
    }

    public void init(@NonNull LogConfig config, LogPrinter ... printers) {
        this.mConfig = config;
        this.mPrinters.addAll(Arrays.asList(printers));
    }

    public LogConfig getConfig() {
        this.check();
        return this.mConfig;
    }

    public List<LogPrinter> getPrinters() {
        this.check();
        return this.mPrinters;
    }

    public void addPrinter(LogPrinter printer) {
        this.check();
        this.mPrinters.add(printer);
    }

    public void removePrinter(LogPrinter printer) {
        this.check();
        if (this.mPrinters != null) {
            this.mPrinters.remove(printer);
        }
    }

    private void check() {
        if (this.mConfig == null || this.mPrinters == null) {
            throw new RuntimeException("LogKitManager \u7684 init \u8fd8\u672a\u521d\u59cb\u5316");
        }
    }

    public static class SingleHolder {
        public static volatile LogKitManager instance = new LogKitManager();
    }
}

