/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit;

import com.log.kit.LogConfig;
import com.log.kit.LogKitManager;
import com.log.kit.print.LogPrinter;
import com.log.kit.util.StackTraceUtil;
import java.util.Arrays;
import java.util.List;

public class LogKit {
    private static final String I_LOG_PACKAGE;

    public static void v(Object ... contents) {
        LogKit.log(2, contents);
    }

    public static void vt(String tag, Object ... contents) {
        LogKit.log(2, tag, contents);
    }

    public static void d(Object ... contents) {
        LogKit.log(3, contents);
    }

    public static void dt(String tag, Object ... contents) {
        LogKit.log(3, tag, contents);
    }

    public static void i(Object ... contents) {
        LogKit.log(4, contents);
    }

    public static void it(String tag, Object ... contents) {
        LogKit.log(4, tag, contents);
    }

    public static void w(Object ... contents) {
        LogKit.log(5, contents);
    }

    public static void wt(String tag, Object ... contents) {
        LogKit.log(5, tag, contents);
    }

    public static void e(Object ... contents) {
        LogKit.log(6, contents);
    }

    public static void et(String tag, Object ... contents) {
        LogKit.log(6, tag, contents);
    }

    public static void a(Object ... contents) {
        LogKit.log(7, contents);
    }

    public static void at(String tag, Object ... contents) {
        LogKit.log(7, tag, contents);
    }

    private static void log(int type, Object ... contents) {
        String globalTag = LogKitManager.getInstance().getConfig().getGlobalTag();
        LogKit.log(type, globalTag, contents);
    }

    private static void log(int type, String tag, Object ... contents) {
        LogConfig config = LogKitManager.getInstance().getConfig();
        LogKit.log(config, type, tag, contents);
    }

    private static void log(LogConfig config, int type, String tag, Object ... contents) {
        List<LogPrinter> printerList;
        String body;
        if (!config.enable()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (config.includeThread()) {
            String threadInfo = LogConfig.I_THREAD_FORMATTER.format(Thread.currentThread());
            sb.append(threadInfo).append("\n");
        }
        if (config.stackTraceDepth() > 0) {
            StackTraceElement[] traceElements = StackTraceUtil.getCroppedRealStackTrack(new Throwable().getStackTrace(), I_LOG_PACKAGE, config.stackTraceDepth());
            String traceInfo = LogConfig.I_STACK_TRACE_FORMATTER.format(traceElements);
            sb.append(traceInfo).append("\n");
        }
        if ((body = LogKit.parseBody(contents, config)) != null) {
            body = body.replace("\\\"", "\"");
        }
        sb.append(body);
        List<LogPrinter> list = printerList = config.printers() != null ? Arrays.asList(config.printers()) : LogKitManager.getInstance().getPrinters();
        if (printerList == null) {
            return;
        }
        for (LogPrinter printer : printerList) {
            printer.print(config, type, tag, sb.toString());
        }
    }

    private static String parseBody(Object[] contents, LogConfig config) {
        if (config.injectJsonParser() != null) {
            if (contents.length == 1 && contents[0] instanceof String) {
                return (String)contents[0];
            }
            return config.injectJsonParser().toJson(contents);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : contents) {
            sb.append(o.toString()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        String className = LogKit.class.getName();
        I_LOG_PACKAGE = className.substring(0, className.lastIndexOf(46) + 1);
    }
}

