/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.print.view;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.log.kit.R;
import com.log.kit.print.view.ILogModel;
import java.util.ArrayList;
import java.util.List;

public class ILogAdapter
extends RecyclerView.Adapter<LogViewHolder> {
    private LayoutInflater inflater;
    private List<ILogModel> mLogs = new ArrayList<ILogModel>();

    public ILogAdapter(LayoutInflater inflater) {
        this.inflater = inflater;
    }

    @NonNull
    public LogViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(R.layout.ilog_item, parent, false);
        return new LogViewHolder(itemView);
    }

    public void onBindViewHolder(LogViewHolder holder, int position) {
        ILogModel logItem = this.mLogs.get(position);
        int color = this.getHighlightColor(logItem.level);
        holder.tagView.setTextColor(color);
        holder.messageView.setTextColor(color);
        holder.tagView.setText((CharSequence)logItem.getFlattened());
        holder.messageView.setText((CharSequence)logItem.log);
    }

    private int getHighlightColor(int logLevel) {
        int highlight;
        switch (logLevel) {
            case 2: {
                highlight = Color.parseColor((String)"#BBBBBB");
                break;
            }
            case 3: {
                highlight = Color.parseColor((String)"#0070BB");
                break;
            }
            case 4: {
                highlight = Color.parseColor((String)"#48BB31");
                break;
            }
            case 5: {
                highlight = Color.parseColor((String)"#BBBB23");
                break;
            }
            case 6: {
                highlight = Color.parseColor((String)"#FF0006");
                break;
            }
            default: {
                highlight = Color.parseColor((String)"#8F0005");
            }
        }
        return highlight;
    }

    public int getItemCount() {
        return this.mLogs.size();
    }

    public void addItem(ILogModel logItem) {
        this.mLogs.add(logItem);
        this.notifyItemInserted(this.mLogs.size() - 1);
    }

    public void clear() {
        this.mLogs.clear();
        this.notifyDataSetChanged();
    }

    public static class LogViewHolder
    extends RecyclerView.ViewHolder {
        TextView tagView;
        TextView messageView;

        LogViewHolder(View itemView) {
            super(itemView);
            this.tagView = (TextView)itemView.findViewById(R.id.tag);
            this.messageView = (TextView)itemView.findViewById(R.id.message);
        }
    }
}

