/*
 * Decompiled with CFR 0.152.
 */
package com.android.xselector.selector;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.support.annotation.ColorRes;
import android.widget.TextView;
import com.android.xselector.interfaces.ISelectorUtil;
import com.android.xselector.utils.XHelper;

public class ColorSelector
implements ISelectorUtil<ColorStateList, TextView> {
    private static ColorSelector mColorSelector;
    public static int TEXT_COLOR;
    public static int HINT_TEXT_COLOR;
    private int textType = TEXT_COLOR;
    private int disabledColor;
    private int focusedColor;
    private int pressedColor;
    private int selectedColor;
    private int normalColor;
    private boolean hasSetDisabledColor = false;
    private boolean hasSetPressedColor = false;
    private boolean hasSetSelectedColor = false;
    private boolean hasSetFocusedColor = false;

    public static ColorSelector getInstance() {
        mColorSelector = new ColorSelector();
        return mColorSelector;
    }

    public ColorSelector defaultColor(@ColorRes int tmpColor) {
        int color;
        this.normalColor = color = XHelper.getColorRes(tmpColor);
        if (!this.hasSetDisabledColor) {
            this.disabledColor = color;
        }
        if (!this.hasSetPressedColor) {
            this.pressedColor = color;
        }
        if (!this.hasSetSelectedColor) {
            this.selectedColor = color;
        }
        if (!this.hasSetFocusedColor) {
            this.focusedColor = color;
        }
        return this;
    }

    public ColorSelector defaultColor(String tmpColor) {
        int color;
        this.normalColor = color = Color.parseColor((String)tmpColor);
        if (!this.hasSetDisabledColor) {
            this.disabledColor = color;
        }
        if (!this.hasSetPressedColor) {
            this.pressedColor = color;
        }
        if (!this.hasSetSelectedColor) {
            this.selectedColor = color;
        }
        if (!this.hasSetFocusedColor) {
            this.focusedColor = color;
        }
        return this;
    }

    public ColorSelector disabledColor(@ColorRes int color) {
        this.disabledColor = XHelper.getColorRes(color);
        this.hasSetDisabledColor = true;
        return this;
    }

    public ColorSelector disabledColor(String color) {
        this.disabledColor = Color.parseColor((String)color);
        this.hasSetDisabledColor = true;
        return this;
    }

    public ColorSelector pressedColor(@ColorRes int color) {
        this.pressedColor = XHelper.getColorRes(color);
        this.hasSetPressedColor = true;
        return this;
    }

    public ColorSelector pressedColor(String color) {
        this.pressedColor = Color.parseColor((String)color);
        this.hasSetPressedColor = true;
        return this;
    }

    public ColorSelector selectedColor(@ColorRes int color) {
        this.selectedColor = XHelper.getColorRes(color);
        this.hasSetSelectedColor = true;
        return this;
    }

    public ColorSelector selectedColor(String color) {
        this.selectedColor = Color.parseColor((String)color);
        this.hasSetSelectedColor = true;
        return this;
    }

    public ColorSelector focusedColor(@ColorRes int color) {
        this.focusedColor = XHelper.getColorRes(color);
        this.hasSetFocusedColor = true;
        return this;
    }

    public ColorSelector focusedColor(String color) {
        this.focusedColor = Color.parseColor((String)color);
        this.hasSetFocusedColor = true;
        return this;
    }

    public ColorSelector selectorColor(int pressedColorResId, int normalColorResId) {
        this.pressedColor = pressedColorResId;
        this.normalColor = normalColorResId;
        return this;
    }

    public ColorSelector textType(int type) {
        this.textType = type;
        return this;
    }

    @Override
    public void into(TextView textView) {
        if (HINT_TEXT_COLOR == this.textType) {
            textView.setHintTextColor(this.create());
        } else {
            textView.setTextColor(this.create());
        }
    }

    @Override
    public ColorStateList build() {
        return this.create();
    }

    public ColorStateList create() {
        int[] colors = new int[]{this.hasSetDisabledColor ? this.disabledColor : this.normalColor, this.hasSetPressedColor ? this.pressedColor : this.normalColor, this.hasSetSelectedColor ? this.selectedColor : this.normalColor, this.hasSetFocusedColor ? this.focusedColor : this.normalColor, this.normalColor};
        return this.getColorStateList(colors);
    }

    public ColorStateList getColorStateList(int[] colors) {
        int[][] states = new int[][]{{-16842910}, {16842919}, {0x10100A1}, {16842908}, new int[0]};
        return new ColorStateList((int[][])states, colors);
    }

    static {
        TEXT_COLOR = 1;
        HINT_TEXT_COLOR = 2;
    }
}

