/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.util;

import android.os.Bundle;
import android.text.TextUtils;
import java.util.Set;

public class UrlUtil {
    public static String toUrlParams(String url, Bundle paramsMp) {
        if (TextUtils.isEmpty((CharSequence)url) || paramsMp == null || paramsMp.size() == 0) {
            return url;
        }
        StringBuilder routeUrl = new StringBuilder(url);
        StringBuilder params = new StringBuilder();
        String paramStr = null;
        Set keySet = paramsMp.keySet();
        for (String key : keySet) {
            Object value = paramsMp.get(key);
            params.append("&" + key + "=" + value);
        }
        if (!TextUtils.isEmpty((CharSequence)params.toString())) {
            paramStr = params.deleteCharAt(0).toString();
        }
        if (!routeUrl.toString().contains("?")) {
            routeUrl.append("?");
        }
        if (!TextUtils.isEmpty((CharSequence)paramStr)) {
            routeUrl.append(paramStr);
        }
        return routeUrl.toString();
    }

    public static UrlEntity toUrlBundle(String url, Bundle tmpParams) {
        String[] params;
        UrlEntity entity = new UrlEntity();
        if (tmpParams == null) {
            tmpParams = new Bundle();
        }
        entity.params = tmpParams;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return entity;
        }
        if (TextUtils.isEmpty((CharSequence)(url = url.trim()))) {
            return entity;
        }
        String[] urlParts = url.split("\\?");
        entity.baseUrl = urlParts[0];
        if (urlParts.length == 1) {
            return entity;
        }
        for (String param : params = urlParts[1].split("&")) {
            String[] keyValue = param.split("=");
            String key = keyValue[0];
            String value = keyValue[1];
            if (value == null) {
                entity.params.putString(keyValue[0], null);
                continue;
            }
            if (value instanceof Boolean) {
                entity.params.putBoolean(keyValue[0], ((Boolean)((Object)value)).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                entity.params.putInt(key, ((Integer)((Object)value)).intValue());
                continue;
            }
            if (value instanceof Number) {
                entity.params.putDouble(key, ((Number)((Object)value)).doubleValue());
                continue;
            }
            if (!(value instanceof String)) continue;
            entity.params.putString(key, value);
        }
        return entity;
    }

    public static class UrlEntity {
        public String baseUrl;
        public Bundle params;
    }
}

