/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.cc.rnbridge.util.RNMapUtil;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import java.util.ArrayList;
import java.util.List;

public class RNArrayUtil {
    public static JSONArray toJSONArray(ReadableArray readableArray) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        block8: for (int i = 0; i < readableArray.size(); ++i) {
            ReadableType type = readableArray.getType(i);
            switch (type) {
                case Null: {
                    jsonArray.add(i, null);
                    continue block8;
                }
                case Boolean: {
                    jsonArray.add(i, (Object)readableArray.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    jsonArray.add(i, (Object)readableArray.getDouble(i));
                    continue block8;
                }
                case String: {
                    jsonArray.add(i, (Object)readableArray.getString(i));
                    continue block8;
                }
                case Map: {
                    jsonArray.add(i, (Object)RNMapUtil.toJSONObject(readableArray.getMap(i)));
                    continue block8;
                }
                case Array: {
                    jsonArray.add(i, (Object)RNArrayUtil.toJSONArray(readableArray.getArray(i)));
                }
            }
        }
        return jsonArray;
    }

    public static Object[] toArray(JSONArray jsonArray) throws JSONException {
        Object[] array = new Object[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object[] value = jsonArray.get(i);
            if (value instanceof JSONObject) {
                value = RNMapUtil.toMap((JSONObject)value);
            }
            if (value instanceof JSONArray) {
                value = RNArrayUtil.toArray((JSONArray)value);
            }
            array[i] = value;
        }
        return array;
    }

    public static Object[] toArray(ReadableArray readableArray) {
        return RNArrayUtil.toArrayList(readableArray).toArray();
    }

    public static WritableArray toWritableArray(ArrayList arrayList) {
        return Arguments.fromList((List)arrayList);
    }

    public static WritableArray toWritableArray(Object array) {
        return Arguments.fromArray((Object)array);
    }

    public static ArrayList toArrayList(ReadableArray readableArray) {
        return Arguments.toList((ReadableArray)readableArray);
    }

    public static WritableArray fromJavaArgs(Object[] args) {
        return Arguments.fromJavaArgs((Object[])args);
    }

    public static WritableArray makeNativeArray(List objects) {
        return Arguments.makeNativeArray((List)objects);
    }
}

