/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.moudles;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.widget.Toast;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cc.rnbridge.base.BaseNativeMethod;
import com.cc.rnbridge.entity.Event;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import javax.annotation.Nonnull;

final class BridgeNativeModule
extends ReactContextBaseJavaModule
implements ActivityEventListener {
    public static final String DEFAULT_MODULE_NAME = "BridgeNativeModule";
    private BaseNativeMethod baseReactMethod;
    private String mNativeModuleName;

    public BridgeNativeModule(@Nonnull ReactApplicationContext reactContext, @Nonnull BaseNativeMethod reactMethod, @Nonnull String nativeModuleName) {
        super(reactContext);
        this.baseReactMethod = reactMethod;
        Assertions.assertNotNull((Object)this.baseReactMethod, (String)"\u8fd8\u6ca1\u6709\u5b9e\u73b0BaseNativeMethod");
        if (TextUtils.isEmpty((CharSequence)nativeModuleName)) {
            nativeModuleName = DEFAULT_MODULE_NAME;
        }
        this.mNativeModuleName = nativeModuleName;
    }

    @ReactMethod
    public void sendEvent(ReadableMap eventMap, Promise promise) {
        String event = JSON.toJSONString((Object)eventMap.toHashMap());
        if (!TextUtils.isEmpty((CharSequence)event)) {
            try {
                Event data = (Event)JSON.parseObject((String)event, (TypeReference)new TypeReference<Event<Object>>(){}, (Feature[])new Feature[0]);
                this.baseReactMethod.sendEvent(this.getCurrentActivity(), data, promise);
            }
            catch (Exception ex) {
                promise.reject(new Throwable("\u51fa\u73b0\u4e86\u975e\u671f\u671b\u7ed3\u679c"));
            }
        } else {
            promise.reject(new Throwable("\u6d88\u606f\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    @ReactMethod
    public void startActivityForResult(String targetPath, Promise promise) {
        Activity mActivity = this.getCurrentActivity();
        this.baseReactMethod.startActivityForResult(mActivity, targetPath, promise);
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        this.baseReactMethod.onActivityResult(activity, requestCode, resultCode, data);
    }

    public void onNewIntent(Intent intent) {
        this.baseReactMethod.onNewIntent(intent);
    }

    @Nonnull
    public String getName() {
        if (TextUtils.isEmpty((CharSequence)this.getNativeModuleName()) && this.getCurrentActivity() != null) {
            Toast.makeText((Context)this.getCurrentActivity(), (CharSequence)"\u8bf7\u521d\u59cb\u5316NativeModuleName,\u4ee5\u4fbfRN\u4e2d\u6b63\u5e38\u4f7f\u7528", (int)0).show();
        }
        return this.getNativeModuleName();
    }

    public String getNativeModuleName() {
        return this.mNativeModuleName;
    }
}

