/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import com.cc.rnbridge.RNBridge;
import com.cc.rnbridge.entity.BundleConfig;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactRootView;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;

public class ReactBridgeActivity
extends AppCompatActivity
implements DefaultHardwareBackBtnHandler {
    public static final String KEY_BUNDLE_CONFIG = "key_bundle_config";
    public static final String DEFAULT_RN_HOST = "rnbridge://app.native.com";
    protected BundleConfig mBundleConfig;
    private ReactRootView mReactRootView;

    public static void openRnUrl(Context mContext, String targetUrl, BundleConfig bundleConfig) {
        if (TextUtils.isEmpty((CharSequence)targetUrl)) {
            return;
        }
        if (targetUrl.startsWith("/")) {
            targetUrl = DEFAULT_RN_HOST + targetUrl;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)targetUrl));
        if (bundleConfig != null) {
            intent.putExtra(KEY_BUNDLE_CONFIG, (Parcelable)bundleConfig);
        }
        mContext.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mBundleConfig = this.getBundleConfig();
        if (this.mBundleConfig != null && !this.isCustomRootView().booleanValue()) {
            this.mReactRootView = new ReactRootView((Context)this);
            this.setContentView((View)this.mReactRootView);
            RNBridge.getInstance().setRootView(this.mReactRootView, this.mBundleConfig);
        }
    }

    protected Boolean isCustomRootView() {
        return false;
    }

    protected ReactRootView getReactRootView() {
        return this.mReactRootView;
    }

    protected BundleConfig getBundleConfig() {
        if (this.getIntent() != null && this.getIntent().hasExtra(KEY_BUNDLE_CONFIG)) {
            return (BundleConfig)this.getIntent().getParcelableExtra(KEY_BUNDLE_CONFIG);
        }
        return null;
    }

    public int getCurrentBundleId() {
        if (this.getBundleConfig() != null) {
            return this.getBundleConfig().getBundleId();
        }
        return 0;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82 && this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().showDevOptionsDialog();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void invokeDefaultOnBackPressed() {
        super.onBackPressed();
    }

    protected void onPause() {
        super.onPause();
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onHostPause((Activity)this);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onHostResume((Activity)this, (DefaultHardwareBackBtnHandler)this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onHostDestroy();
        }
    }

    public void onBackPressed() {
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onBackPressed();
        } else {
            super.onBackPressed();
        }
    }

    private ReactInstanceManager getReactInstanceManager() {
        return RNBridge.getInstance().getReactInstanceManager(this.getCurrentBundleId());
    }
}

