/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.SystemClock;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Xml;
import com.liujc.baseutils.common.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class PhoneUtil {
    private static final String CMCC_ISP = "46000";
    private static final String CMCC2_ISP = "46002";
    private static final String CMCC3_ISP = "46007";
    private static final String CU_ISP = "46001";
    private static final String CT_ISP = "46003";

    private PhoneUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null && tm.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIMEI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getDeviceId() : null;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIMSI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getSubscriberId() : null;
    }

    public static int getPhoneType(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getPhoneType() : -1;
    }

    public static boolean isSimCardReady(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null && tm.getSimState() == 5;
    }

    public static String getSimOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getSimOperatorName() : null;
    }

    public static String getSimOperatorByMnc(Context context) {
        String operator;
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String string = operator = tm != null ? tm.getSimOperator() : null;
        if (operator == null) {
            return null;
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    public static String getPhoneStatus(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String str = "";
        str = str + "DeviceId(IMEI) = " + tm.getDeviceId() + "\n";
        str = str + "DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n";
        str = str + "Line1Number = " + tm.getLine1Number() + "\n";
        str = str + "NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n";
        str = str + "NetworkOperator = " + tm.getNetworkOperator() + "\n";
        str = str + "NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n";
        str = str + "NetworkType = " + tm.getNetworkType() + "\n";
        str = str + "honeType = " + tm.getPhoneType() + "\n";
        str = str + "SimCountryIso = " + tm.getSimCountryIso() + "\n";
        str = str + "SimOperator = " + tm.getSimOperator() + "\n";
        str = str + "SimOperatorName = " + tm.getSimOperatorName() + "\n";
        str = str + "SimSerialNumber = " + tm.getSimSerialNumber() + "\n";
        str = str + "SimState = " + tm.getSimState() + "\n";
        str = str + "SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n";
        str = str + "VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n";
        return str;
    }

    public static void dial(Context context, String phoneNumber) {
        context.startActivity(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    public static void call(Context context, String phoneNumber) {
        context.startActivity(new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    public static void sendSms(Context context, String phoneNumber, String content) {
        Uri uri = Uri.parse((String)("smsto:" + (StringUtil.isEmpty(phoneNumber) ? "" : phoneNumber)));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", StringUtil.isEmpty(content) ? "" : content);
        context.startActivity(intent);
    }

    public static void sendSmsSilent(Context context, String phoneNumber, String content) {
        if (StringUtil.isEmpty(content)) {
            return;
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (content.length() >= 70) {
            ArrayList ms = smsManager.divideMessage(content);
            for (String str : ms) {
                smsManager.sendTextMessage(phoneNumber, null, str, sentIntent, null);
            }
        } else {
            smsManager.sendTextMessage(phoneNumber, null, content, sentIntent, null);
        }
    }

    public static List<HashMap<String, String>> getAllContactInfo(Context context) {
        SystemClock.sleep((long)3000L);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        ContentResolver resolver = context.getContentResolver();
        Uri raw_uri = Uri.parse((String)"content://com.android.contacts/raw_contacts");
        Uri date_uri = Uri.parse((String)"content://com.android.contacts/data");
        Cursor cursor = resolver.query(raw_uri, new String[]{"contact_id"}, null, null, null);
        while (cursor.moveToNext()) {
            String contact_id = cursor.getString(0);
            if (StringUtil.isEmpty(contact_id)) continue;
            Cursor c = resolver.query(date_uri, new String[]{"data1", "mimetype"}, "raw_contact_id=?", new String[]{contact_id}, null);
            HashMap<String, String> map = new HashMap<String, String>();
            while (c.moveToNext()) {
                String data1 = c.getString(0);
                String mimetype = c.getString(1);
                if (mimetype.equals("vnd.android.cursor.item/phone_v2")) {
                    map.put("phone", data1);
                    continue;
                }
                if (!mimetype.equals("vnd.android.cursor.item/name")) continue;
                map.put("name", data1);
            }
            list.add(map);
            c.close();
        }
        cursor.close();
        return list;
    }

    public static void getContactNum() {
        Log.d((String)"tips", (String)"U should copy the following code.");
    }

    public static void getAllSMS(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://sms");
        Cursor cursor = resolver.query(uri, new String[]{"address", "date", "type", "body"}, null, null, null);
        int count = cursor.getCount();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        try {
            xmlSerializer.setOutput((OutputStream)new FileOutputStream(new File("/mnt/sdcard/backupsms.xml")), "utf-8");
            xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
            xmlSerializer.startTag(null, "smss");
            while (cursor.moveToNext()) {
                SystemClock.sleep((long)1000L);
                xmlSerializer.startTag(null, "sms");
                xmlSerializer.startTag(null, "address");
                String address = cursor.getString(0);
                xmlSerializer.text(address);
                xmlSerializer.endTag(null, "address");
                xmlSerializer.startTag(null, "date");
                String date = cursor.getString(1);
                xmlSerializer.text(date);
                xmlSerializer.endTag(null, "date");
                xmlSerializer.startTag(null, "type");
                String type = cursor.getString(2);
                xmlSerializer.text(type);
                xmlSerializer.endTag(null, "type");
                xmlSerializer.startTag(null, "body");
                String body = cursor.getString(3);
                xmlSerializer.text(body);
                xmlSerializer.endTag(null, "body");
                xmlSerializer.endTag(null, "sms");
                System.out.println("address:" + address + "   date:" + date + "  type:" + type + "  body:" + body);
            }
            xmlSerializer.endTag(null, "smss");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

