/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.liujc.baseutils.view.ToastUitl;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class EventReminderUtils {
    private static String CALANDER_URL = "content://com.android.calendar/calendars";
    private static String CALANDER_EVENT_URL = "content://com.android.calendar/events";
    private static String CALANDER_REMIDER_URL = "content://com.android.calendar/reminders";
    private static String CALENDARS_NAME = "table";
    private static String CALENDARS_ACCOUNT_NAME = "table@table.com";
    private static String CALENDARS_ACCOUNT_TYPE = "com.android.table";
    private static String CALENDARS_DISPLAY_NAME = "\u5e05\u5e05";
    public static String DATETIME_FORMAT_PATTERN = "yyyy-MM-dd HH:mm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCalendarEvent(Context context) {
        try (Cursor eventCursor = context.getContentResolver().query(Uri.parse((String)CALANDER_EVENT_URL), null, null, null, null);){
            if (eventCursor == null) {
                return;
            }
            if (eventCursor.getCount() > 0) {
                eventCursor.moveToFirst();
                while (!eventCursor.isAfterLast()) {
                    String eventTitle = eventCursor.getString(eventCursor.getColumnIndex("title"));
                    if (eventTitle.startsWith("\u6807\u9898\u63d0\u9192")) {
                        int id = eventCursor.getInt(eventCursor.getColumnIndex("_id"));
                        Uri deleteUri = ContentUris.withAppendedId((Uri)Uri.parse((String)CALANDER_EVENT_URL), (long)id);
                        int rows = context.getContentResolver().delete(deleteUri, null, null);
                        if (rows == -1) {
                            return;
                        }
                    }
                    eventCursor.moveToNext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean selectCalendarEvent(Context context, String data) {
        try (Cursor eventCursor = context.getContentResolver().query(Uri.parse((String)CALANDER_EVENT_URL), null, null, null, null);){
            if (eventCursor == null) {
                boolean bl = false;
                return bl;
            }
            if (eventCursor.getCount() > 0) {
                eventCursor.moveToFirst();
                while (!eventCursor.isAfterLast()) {
                    String eventTitle = eventCursor.getString(eventCursor.getColumnIndex("title"));
                    if (eventTitle.equals("\u6807\u9898\u63d0\u9192" + data)) {
                        boolean bl = true;
                        return bl;
                    }
                    eventCursor.moveToNext();
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void addCalendarEvent(Context context, String title, String description, String beginTime, String endTime) {
        int calId = EventReminderUtils.checkAndAddCalendarAccount(context);
        if (calId < 0) {
            ToastUitl.showShort("\u83b7\u53d6\u8d26\u6237id\u5931\u8d25\u76f4\u63a5\u8fd4\u56de\uff0c\u6dfb\u52a0\u65e5\u5386\u4e8b\u4ef6\u5931\u8d25");
            return;
        }
        ContentValues event = new ContentValues();
        event.put("title", title);
        event.put("description", description);
        event.put("calendar_id", Integer.valueOf(calId));
        long start = EventReminderUtils.getDateLong(beginTime + " 9:00");
        long end = EventReminderUtils.getDateLong(endTime + " 12:00");
        event.put("dtstart", Long.valueOf(start));
        event.put("dtend", Long.valueOf(end));
        event.put("hasAlarm", Integer.valueOf(1));
        event.put("eventTimezone", "Asia/Shanghai");
        Uri newEvent = context.getContentResolver().insert(Uri.parse((String)CALANDER_EVENT_URL), event);
        if (newEvent == null) {
            ToastUitl.showShort("\u6dfb\u52a0\u65e5\u5386\u4e8b\u4ef6\u5931\u8d25\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        ContentValues values = new ContentValues();
        values.put("event_id", Long.valueOf(ContentUris.parseId((Uri)newEvent)));
        values.put("minutes", Integer.valueOf(10));
        values.put("method", Integer.valueOf(1));
        Uri uri = context.getContentResolver().insert(Uri.parse((String)CALANDER_REMIDER_URL), values);
        if (uri == null) {
            ToastUitl.showShort("\u6dfb\u52a0\u95f9\u949f\u63d0\u9192\u5931\u8d25\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        ToastUitl.showShort("\u6dfb\u52a0\u6210\u529f");
    }

    private static int checkAndAddCalendarAccount(Context context) {
        int oldId = EventReminderUtils.checkCalendarAccount(context);
        Log.e((String)"TAG", (String)("\u8d26\u53f7ID:" + oldId));
        if (oldId >= 0) {
            return oldId;
        }
        long addId = EventReminderUtils.addCalendarAccount(context);
        if (addId >= 0L) {
            return EventReminderUtils.checkCalendarAccount(context);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int checkCalendarAccount(Context context) {
        try (Cursor userCursor = context.getContentResolver().query(Uri.parse((String)CALANDER_URL), null, null, null, null);){
            if (userCursor == null) {
                int n = -1;
                return n;
            }
            int count = userCursor.getCount();
            if (count > 0) {
                userCursor.moveToFirst();
                int n = userCursor.getInt(userCursor.getColumnIndex("_id"));
                return n;
            }
            int n = -1;
            return n;
        }
    }

    private static long addCalendarAccount(Context context) {
        TimeZone timeZone = TimeZone.getDefault();
        ContentValues value = new ContentValues();
        value.put("name", CALENDARS_NAME);
        value.put("account_name", CALENDARS_ACCOUNT_NAME);
        value.put("account_type", CALENDARS_ACCOUNT_TYPE);
        value.put("calendar_displayName", CALENDARS_DISPLAY_NAME);
        value.put("visible", Integer.valueOf(1));
        value.put("calendar_color", Integer.valueOf(-16776961));
        value.put("calendar_access_level", Integer.valueOf(700));
        value.put("sync_events", Integer.valueOf(1));
        value.put("calendar_timezone", timeZone.getID());
        value.put("ownerAccount", CALENDARS_ACCOUNT_NAME);
        value.put("canOrganizerRespond", Integer.valueOf(0));
        Uri calendarUri = Uri.parse((String)CALANDER_URL);
        calendarUri = calendarUri.buildUpon().appendQueryParameter("caller_is_syncadapter", "true").appendQueryParameter("account_name", CALENDARS_ACCOUNT_NAME).appendQueryParameter("account_type", CALENDARS_ACCOUNT_TYPE).build();
        Uri result = context.getContentResolver().insert(calendarUri, value);
        long id = result == null ? -1L : ContentUris.parseId((Uri)result);
        return id;
    }

    public static long getDateLong(String date_str) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT_PATTERN);
            return sdf.parse(date_str).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

