/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.liujc.baseutils.file.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogUtil {
    public static final String LOG_D = "D";
    public static final String LOG_I = "I";
    public static final String LOG_E = "E";
    public static final String LOG_BEGIN = "begin";
    public static final String LOG_END = "end";
    private static Boolean LOG_SWITCH = true;
    private static Boolean LOG_TO_FILE = true;
    private static String LOG_TAG = "LogUtil";
    private static char LOG_TYPE = (char)118;
    private static int LOG_SAVE_DAYS = 7;
    private static final SimpleDateFormat LOG_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
    private static final SimpleDateFormat FILE_SUFFIX = new SimpleDateFormat("yyyy-MM-dd");
    private static String LOG_FILE_PATH = LogUtil.getLogFilePath();
    private static String LOG_FILE_NAME = "Log";
    public static final String LOG_FILE_EXTENSION = ".txt";

    public static int d(String msg) {
        if (LOG_SWITCH.booleanValue()) {
            String[] classMethod = LogUtil.getClassMethod(new Exception(), LOG_TAG, LOG_D);
            return LogUtil.d(classMethod[0], classMethod[1], msg);
        }
        return 0;
    }

    public static int d(String tag, String msg) {
        if (LOG_SWITCH.booleanValue()) {
            String[] classMethod = LogUtil.getClassMethod(new Exception(), LOG_TAG, LOG_D);
            return LogUtil.d(tag, classMethod[1], msg);
        }
        return 0;
    }

    public static int d(String tag, String method, String msg) {
        int ret1 = Log.d((String)tag, (String)(method + "#" + msg));
        if (LOG_TO_FILE.booleanValue()) {
            LogUtil.saveLogToFile(LOG_D, tag, method, "#", msg);
        }
        return ret1;
    }

    public static int i(String msg) {
        if (LOG_SWITCH.booleanValue()) {
            String[] classMethod = LogUtil.getClassMethod(new Exception(), LOG_TAG, LOG_D);
            return LogUtil.i(classMethod[0], classMethod[1], msg);
        }
        return 0;
    }

    public static int i(String tag, String method, String msg) {
        int ret1 = Log.i((String)tag, (String)(method + "#" + msg));
        if (LOG_TO_FILE.booleanValue()) {
            LogUtil.saveLogToFile(LOG_I, tag, method, "#", msg);
        }
        return ret1;
    }

    public static int i(String tag, String method, String sipId, String status, String msg) {
        int ret1 = Log.i((String)tag, (String)(method + "-" + sipId + "-" + status + "-" + msg));
        if (LOG_TO_FILE.booleanValue()) {
            LogUtil.saveLogToFile(LOG_I, tag, method, sipId, status, msg);
        }
        return ret1;
    }

    public static int begin(String msg) {
        String[] classMethod = LogUtil.getClassMethod(new Exception(), LOG_TAG, LOG_BEGIN);
        return LogUtil.i(classMethod[0], classMethod[1], "#", LOG_BEGIN, msg);
    }

    public static int end(String msg) {
        String[] classMethod = LogUtil.getClassMethod(new Exception(), LOG_TAG, LOG_END);
        return LogUtil.i(classMethod[0], classMethod[1], "#", LOG_END, msg);
    }

    public static int e(String msg) {
        return LogUtil.e(msg, null);
    }

    public static int e(Throwable e) {
        return LogUtil.e("Throwable", e);
    }

    public static int e(String msg, Throwable e) {
        if (LOG_SWITCH.booleanValue()) {
            String[] classMethod = LogUtil.getClassMethod(new Exception(), LOG_TAG, LOG_E);
            return LogUtil.e(classMethod[0], classMethod[1], msg, e);
        }
        return 0;
    }

    public static int e(String tag, String method, String msg, Throwable e) {
        int ret1 = Log.e((String)tag, (String)(method + "#" + msg), (Throwable)e);
        if (LOG_TO_FILE.booleanValue()) {
            LogUtil.saveLogToFile(LOG_E, tag, method, "#", msg + ":" + e.getLocalizedMessage());
        }
        return ret1;
    }

    public static void saveLogToFile(String logLevel, String tag, String method, String sipId, String strMessage) {
        LogUtil.saveLogToFile(logLevel, tag, method, sipId, "", strMessage);
    }

    public static String[] getClassMethod(Exception e, String defaultClass, String defaultMethod) {
        StackTraceElement el;
        String className;
        String methodName;
        block3: {
            methodName = "";
            className = "";
            el = null;
            try {
                el = e.getStackTrace()[1];
                className = el.getClassName();
                className = className.substring(className.lastIndexOf(".") + 1);
                methodName = el.getMethodName();
            }
            catch (Exception ex) {
                if (TextUtils.isEmpty((CharSequence)className)) {
                    className = defaultClass;
                }
                if (!TextUtils.isEmpty((CharSequence)methodName)) break block3;
                methodName = defaultMethod;
            }
        }
        el = null;
        return new String[]{className, methodName};
    }

    public static String getLogFilePath() {
        String sdCardPath = LogUtil.getSDPath();
        if (TextUtils.isEmpty((CharSequence)sdCardPath)) {
            return "";
        }
        return sdCardPath + File.separator + "androidutil" + File.separator + "log";
    }

    public static String getSDPath() {
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            return Environment.getExternalStorageDirectory().toString();
        }
        return "";
    }

    public static synchronized void saveLogToFile(String logLevel, String tag, String method, String sipId, String status, String content) {
        if (TextUtils.isEmpty((CharSequence)LOG_FILE_PATH)) {
            Log.d((String)"FileService", (String)"filePath is null");
            return;
        }
        File dest = new File(LOG_FILE_PATH);
        if (!dest.exists() && !dest.mkdirs()) {
            return;
        }
        dest = null;
        Date nowtime = new Date();
        String curDate = FILE_SUFFIX.format(nowtime);
        String date = LOG_FORMAT.format(nowtime);
        StringBuilder logCon = new StringBuilder();
        logCon.append("[").append(date).append("-").append(logLevel).append("-").append(Process.myPid()).append("-").append(tag).append("-").append(method).append("-").append(sipId);
        if (!TextUtils.isEmpty((CharSequence)status)) {
            logCon.append("-").append(status);
        }
        logCon.append("]").append(content);
        File curLogFile = new File(LOG_FILE_PATH, LOG_FILE_NAME + curDate + LOG_FILE_EXTENSION);
        try {
            if (!curLogFile.exists()) {
                curLogFile.createNewFile();
            }
            FileWriter filerWriter = new FileWriter(curLogFile, true);
            BufferedWriter bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(logCon.toString());
            bufWriter.newLine();
            bufWriter.close();
            filerWriter.close();
        }
        catch (Exception e) {
            Log.e((String)"FileService", (String)"write log file error", (Throwable)e);
        }
    }

    public static void autoClear(final int autoClearDay) {
        FileUtil.delete(LOG_FILE_PATH, new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                String s = FileUtil.getFileNameNoExtension(filename);
                int day = autoClearDay < 0 ? autoClearDay : -1 * autoClearDay;
                Date nowtime = new Date();
                String curDate = FILE_SUFFIX.format(nowtime);
                String date = LOG_FILE_NAME + curDate;
                return date.compareTo(s) >= 0;
            }
        });
    }
}

