package com.liujc.baseutils.view;

import android.os.CountDownTimer;
import android.widget.TextView;

public class CountTimeUtil {
    private static CountTimeUtil ourInstance = new CountTimeUtil();

    public static CountTimeUtil getInstance() {
        return ourInstance;
    }

    private boolean mRunning = false;
    private String cache = "60";
    private TextView mBindView = null;
    private CountDownTimer countDownTimer = null;

    private CountTimeUtil() {
        countDownTimer = new CountDownTimer(60000, 1000) {
            @Override
            public void onTick(long l) {
                cache = "" + (l / 1000);
                if (mBindView != null) {
                    mBindView.setText(cache + "s");
                }
            }

            @Override
            public void onFinish() {
                mRunning = false;
                if (mBindView != null) {
                    mBindView.setEnabled(true);
                    mBindView.setText("重新发送");
                }
            }
        };

    }

    public boolean isRunning() {
        return mRunning;
    }

    public void bindView(TextView textView) {
        reset();
        if (isRunning()) {
            textView.setEnabled(false);
            textView.setText(cache + "s");
        }
        mBindView = textView;
    }

    public void unBindView() {
        mBindView = null;
    }

    public void start() {
        if(mBindView!=null){
            mBindView.setEnabled(false);
        }
        mRunning = true;
        countDownTimer.start();
    }

    public void reset() {
        countDownTimer.cancel();
        mRunning = false;
        cache = "60";
        if(mBindView!=null){
            mBindView.setEnabled(true);
            mBindView.setText("重新发送");
        }
    }
}
