package com.liujc.baseutils.file;

import android.content.Context;

import java.lang.reflect.Field;

/**
 * 类名称：ResourceUtil
 * 创建者：Create by liujc
 * 创建时间：Create on 2016/11/16 11:49
 * 描述：通过反射根据资源的名字获取其ID值
 * 最近修改时间：2016/11/16 11:49
 * 修改人：Modify by liujc
 */
public class ResourceUtil {

    public static final String POINT = "";
    public static final String R = "R";
    public static final String JOIN = "$";
    public static final String ANIM = "anim";
    public static final String ATTR = "attr";
    public static final String COLOR = "color";
    public static final String DIMEN = "dimen";
    public static final String DRAWABLE = "drawable";
    public static final String ID = "id";
    public static final String LAYOUT = "layout";
    public static final String MENU = "menu";
    public static final String RAW = "raw";
    public static final String STRING = "string";
    public static final String STYLE = "style";
    public static final String STYLEABLE = "styleable";

    /**
     * Don't let anyone instantiate this class.
     */
    private ResourceUtil() {
        throw new Error("Do not need instantiate!");
    }

    /**
     * 获取动画ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getAnim(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + ANIM)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取属性ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getAttr(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + ATTR)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取颜色ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getColor(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + COLOR)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取尺寸ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getDimen(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + DIMEN)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取图片ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getDrawable(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN
                            + DRAWABLE).getDeclaredField(name)
                    .get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getId(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + ID)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取布局ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getLayout(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN
                            + LAYOUT).getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取菜单ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getMenu(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + MENU)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取RAW ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getRaw(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + RAW)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取字符串ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getString(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN
                            + STRING).getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取样式ID
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int getStyle(Context context, String name) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN + STYLE)
                    .getDeclaredField(name).get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 获取自定义属性组
     *
     * @param context 上下文
     * @param name    名称
     */
    public static int[] getStyleable(Context context, String name) {
        try {
            return (int[]) Class
                    .forName(context.getPackageName() + POINT + R + JOIN
                            + STYLEABLE).getDeclaredField(name)
                    .get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取自定义属性
     *
     * @param context       上下文
     * @param styleableName 属性组名称
     * @param attributeName 属性名称
     */
    public static int getStyleableAttribute(Context context,
                                            String styleableName, String attributeName) {
        try {
            return (Integer) Class
                    .forName(context.getPackageName() + POINT + R + JOIN
                            + STYLEABLE)
                    .getDeclaredField(styleableName + "_" + attributeName)
                    .get(null);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
    /**
     * 根据名字获取布局文件的id
     *
     * @param context
     * @param name
     *            布局文件的名字
     * @return
     */
    public static int getLayoutIdByName(Context context, String name) {
        return getIdByName(context, "layout", name);
    }

    /**
     * 据名字获取动画文件的id
     * @param context
     * @param name
     * @return
     */
    public static int getAnimIdByName(Context context, String name) {
        return getIdByName(context, "anim", name);
    }
    /**
     * 根据名字获取图片的id
     *
     * @param context
     * @param name
     *            图片的名字
     * @return
     */
    public static int getDrawableIdByName(Context context, String name) {
        return getIdByName(context, "drawable", name);
    }

    /**
     * 根据名字获取string.xml文件中字符串的id
     *
     * @param context
     * @param name
     *            字符串的名字
     * @return
     */
    public static int getStringIdByName(Context context, String name) {
        return getIdByName(context, "string", name);
    }

    /**
     * 根据名字获取布局文件中组件的id
     *
     * @param context
     * @param name
     *            组件id属性的名字
     * @return
     */
    public static int getViewIdByName(Context context, String name) {
        return getIdByName(context, "id", name);
    }

    /**
     * 根据名字获取颜色的id
     *
     * @param context
     * @param name
     *            颜色的名字
     * @return
     */
    public static int getColorIdByName(Context context, String name) {
        return getIdByName(context, "color", name);
    }

    /**
     * 根据名字获取style的id
     *
     * @param context
     * @param name  style的名字
     * @return
     */
    public static int getStyleIdByName(Context context, String name) {
        return getIdByName(context, "style", name);
    }

    /**
     * 根据名字获取Attr的id
     *
     * @param context
     * @param name  Attr的名字
     * @return
     */
    public static int getAttrIdByName(Context context, String name) {
        return getIdByName(context, "attr", name);
    }
    /**
     * 根据名字获取Attr的ids
     *
     * @param context
     * @param name  Attr的名字
     * @return
     */
    public static int[] getAttrsIdByName(Context context, String name) {
        return getIdsByName(context, "attr", name);
    }
    /**
     * 根据名字获取尺寸（dimen）的id
     *
     * @param context
     * @param name
     *            名字
     * @return
     */
    public static int getDimenIdByName(Context context, String name) {
        return getIdByName(context, "dimen", name);
    }

    /**
     * 根据资源类型和名字获取资源id
     *
     * @param context
     * @param className
     *            资源类型，如"drawable"/"layout"/"id"/"string"等
     * @param name
     *            资源的名字
     * @return
     */
    private static int getIdByName(Context context, String className,
                                   String name) {
        String packageName = context.getPackageName();
        Class r = null;
        int id = 0;
        try {
            r = Class.forName(packageName + ".R");

            Class[] classes = r.getClasses();
            Class desireClass = null;

            for (int i = 0; i < classes.length; ++i) {
                if (classes[i].getName().split("\\$")[1].equals(className)) {
                    desireClass = classes[i];
                    break;
                }
            }

            if (desireClass != null)
                id = desireClass.getField(name).getInt(desireClass);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }

        return id;
    }

    /**
     * 根据资源类型和名字获取资源id
     *
     * @param context
     * @param className
     *            资源类型，如"drawable"/"layout"/"id"/"string"等
     * @param name
     *            资源的名字
     * @return
     */
    private static int[] getIdsByName(Context context, String className,
                                      String name) {
        String packageName = context.getPackageName();
        Class r = null;
        int[] id = new int[32];
        try {
            r = Class.forName(packageName + ".R");

            Class[] classes = r.getClasses();
            Class desireClass = null;

            for (int i = 0; i < classes.length; ++i) {
                if (classes[i].getName().split("\\$")[1].equals(className)) {
                    desireClass = classes[i];
                    break;
                }
            }

            if (desireClass != null){
                Field field = desireClass.getDeclaredField(name);
                field.setAccessible(true);
                id = (int[]) field.get(desireClass);
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }

        return id;
    }
}
