/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.util;

import com.android.sdklib.util.LineUtil;
import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLineParser {
    public static final String GLOBAL_FLAG_VERB = "@@internal@@";
    public static final String NO_VERB_OBJECT = "";
    public static final String KEY_HELP = "help";
    public static final String KEY_VERBOSE = "verbose";
    public static final String KEY_SILENT = "silent";
    private String mVerbRequested;
    private String mDirectObjectRequested;
    private final String[][] mActions;
    private static final int ACTION_VERB_INDEX = 0;
    private static final int ACTION_OBJECT_INDEX = 1;
    private static final int ACTION_DESC_INDEX = 2;
    private static final int ACTION_ALT_OBJECT_INDEX = 3;
    private final HashMap<String, Arg> mArguments = new HashMap();
    private final ILogger mLog;

    public CommandLineParser(ILogger logger, String[][] actions) {
        this.mLog = logger;
        this.mActions = actions;
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "v", KEY_VERBOSE, "Verbose mode, shows errors, warnings and all messages.", false);
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "s", KEY_SILENT, "Silent mode, shows errors only.", false);
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "h", KEY_HELP, "Help on a specific command.", false);
    }

    public boolean acceptLackOfVerb() {
        return false;
    }

    public boolean isVerbose() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_VERBOSE);
    }

    public boolean isSilent() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_SILENT);
    }

    public boolean isHelpRequested() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_HELP);
    }

    public String getVerb() {
        return this.mVerbRequested;
    }

    public String getDirectObject() {
        return this.mDirectObjectRequested;
    }

    public Object getValue(String verb, String directObject, String longFlagName) {
        if (verb != null && directObject != null) {
            String key = verb + '/' + directObject + '/' + longFlagName;
            Arg arg = this.mArguments.get(key);
            return arg.getCurrentValue();
        }
        Object lastDefault = null;
        for (Arg arg : this.mArguments.values()) {
            if (!arg.getLongArg().equals(longFlagName) || verb != null && !arg.getVerb().equals(verb) || directObject != null && !arg.getDirectObject().equals(directObject)) continue;
            if (arg.isInCommandLine()) {
                return arg.getCurrentValue();
            }
            if (arg.getCurrentValue() == null) continue;
            lastDefault = arg.getCurrentValue();
        }
        return lastDefault;
    }

    protected void setValue(String verb, String directObject, String longFlagName, Object value) {
        String key = verb + '/' + directObject + '/' + longFlagName;
        Arg arg = this.mArguments.get(key);
        arg.setCurrentValue(value);
    }

    /*
     * Exception decompiling
     */
    public void parseArgs(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Arg findLongArg(String verb, String directObject, String longName) {
        if (verb == null) {
            verb = GLOBAL_FLAG_VERB;
        }
        if (directObject == null) {
            directObject = NO_VERB_OBJECT;
        }
        String key = verb + '/' + directObject + '/' + longName;
        return this.mArguments.get(key);
    }

    protected Arg findShortArg(String verb, String directObject, String shortName) {
        if (verb == null) {
            verb = GLOBAL_FLAG_VERB;
        }
        if (directObject == null) {
            directObject = NO_VERB_OBJECT;
        }
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            Arg arg = entry.getValue();
            if (!arg.getVerb().equals(verb) || !arg.getDirectObject().equals(directObject) || !shortName.equals(arg.getShortArg())) continue;
            return arg;
        }
        return null;
    }

    public void printHelpAndExit(String errorFormat, Object ... args) {
        this.printHelpAndExitForAction(null, null, errorFormat, args);
    }

    public void printHelpAndExitForAction(String verb, String directObject, String errorFormat, Object ... args) {
        if (errorFormat != null && !errorFormat.isEmpty()) {
            this.stderr(errorFormat, args);
        }
        this.stdout(NO_VERB_OBJECT, new Object[0]);
        Object[] objectArray = new Object[1];
        objectArray[0] = verb == null ? (this.acceptLackOfVerb() ? "[action]" : "action") : verb + (directObject == null ? NO_VERB_OBJECT : " " + directObject);
        this.stdout("Usage:\n  avdmanager [global options] %s [action options]\n\nGlobal options:", objectArray);
        this.listOptions(GLOBAL_FLAG_VERB, NO_VERB_OBJECT);
        if (verb == null || directObject == null) {
            this.stdout(NO_VERB_OBJECT, new Object[0]);
            this.stdout("Valid actions are composed of a verb and an optional direct object:", new Object[0]);
            for (String[] action : this.mActions) {
                if (verb != null && !verb.equals(action[0])) continue;
                this.stdout("- %1$6s %2$-13s: %3$s", action[0], action[1], action[2]);
            }
        }
        if (verb == null && this.acceptLackOfVerb() && this.getDefaultVerb() != null) {
            this.stdout(NO_VERB_OBJECT, new Object[0]);
            this.stdout("If a verb is not specified, the default is '%s'", this.getDefaultVerb());
        }
        if (verb != null) {
            for (String[] action : this.mActions) {
                if (verb != null && !verb.equals(action[0]) || directObject != null && !directObject.equals(action[1])) continue;
                this.stdout(NO_VERB_OBJECT, new Object[0]);
                this.stdout("Action \"%1$s %2$s\":", action[0], action[1]);
                this.stdout("  %1$s", action[2]);
                this.stdout("Options:", new Object[0]);
                this.listOptions(action[0], action[1]);
            }
        }
        this.exit();
    }

    protected String getDefaultVerb() {
        return null;
    }

    protected void listOptions(String verb, String directObject) {
        Arg arg;
        int numOptions = 0;
        int longArgLen = 8;
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            int n;
            arg = entry.getValue();
            if (!arg.getVerb().equals(verb) || !arg.getDirectObject().equals(directObject) || (n = arg.getLongArg().length()) <= longArgLen) continue;
            longArgLen = n;
        }
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            arg = entry.getValue();
            if (!arg.getVerb().equals(verb) || !arg.getDirectObject().equals(directObject)) continue;
            String value = NO_VERB_OBJECT;
            String required = NO_VERB_OBJECT;
            if (arg.isMandatory()) {
                required = " [required]";
            } else {
                if (arg.getDefaultValue() instanceof String[]) {
                    for (String v : (String[])arg.getDefaultValue()) {
                        if (!value.isEmpty()) {
                            value = value + ", ";
                        }
                        value = value + v;
                    }
                } else if (arg.getDefaultValue() != null) {
                    Object v = arg.getDefaultValue();
                    if (arg.getMode() != Mode.BOOLEAN || v.equals(Boolean.TRUE)) {
                        value = v.toString();
                    }
                }
                if (!value.isEmpty()) {
                    value = " [Default: " + value + "]";
                }
            }
            String longArgWidth = Integer.toString(longArgLen + 2);
            String output = String.format("  %1$-2s %2$-" + longArgWidth + "s: %3$s%4$s%5$s", !arg.getShortArg().isEmpty() ? "-" + arg.getShortArg() : NO_VERB_OBJECT, !arg.getLongArg().isEmpty() ? "--" + arg.getLongArg() : NO_VERB_OBJECT, arg.getDescription(), value, required);
            this.stdout(output, new Object[0]);
            ++numOptions;
        }
        if (numOptions == 0) {
            this.stdout("  No options", new Object[0]);
        }
    }

    protected void define(Mode mode, boolean mandatory, String verb, String directObject, String shortName, String longName, String description, Object defaultValue) {
        assert (verb != null);
        assert (!mandatory || mode != Mode.BOOLEAN);
        assert (shortName != null);
        assert (longName != null);
        assert (!shortName.isEmpty() || !longName.isEmpty());
        if (directObject == null) {
            directObject = NO_VERB_OBJECT;
        }
        String key = verb + '/' + directObject + '/' + longName;
        this.mArguments.put(key, new Arg(mode, mandatory, verb, directObject, shortName, longName, description, defaultValue));
    }

    protected void exit() {
        System.exit(1);
    }

    protected void stdout(String format, Object ... args) {
        String output = String.format(format, args);
        output = LineUtil.reflowLine(output);
        this.mLog.info("%s\n", new Object[]{output});
    }

    protected void stderr(String format, Object ... args) {
        this.mLog.error(null, format, args);
    }

    protected ILogger getLog() {
        return this.mLog;
    }

    protected static class Arg {
        private final String mVerb;
        private final String mDirectObject;
        private final String mShortName;
        private final String mLongName;
        private final String mDescription;
        private final Object mDefaultValue;
        private final Mode mMode;
        private final boolean mMandatory;
        private Object mCurrentValue;
        private boolean mInCommandLine;

        public Arg(Mode mode, boolean mandatory, String verb, String directObject, String shortName, String longName, String description, Object defaultValue) {
            this.mMode = mode;
            this.mMandatory = mandatory;
            this.mVerb = verb;
            this.mDirectObject = directObject;
            this.mShortName = shortName;
            this.mLongName = longName;
            this.mDescription = description;
            this.mDefaultValue = defaultValue;
            this.mInCommandLine = false;
            this.mCurrentValue = defaultValue instanceof String[] ? ((String[])defaultValue)[0] : this.mDefaultValue;
        }

        public boolean isMandatory() {
            return this.mMandatory;
        }

        public String getShortArg() {
            return this.mShortName;
        }

        public String getLongArg() {
            return this.mLongName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getVerb() {
            return this.mVerb;
        }

        public String getDirectObject() {
            return this.mDirectObject;
        }

        public Object getDefaultValue() {
            return this.mDefaultValue;
        }

        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        public void setCurrentValue(Object currentValue) {
            this.mCurrentValue = currentValue;
        }

        public Mode getMode() {
            return this.mMode;
        }

        public boolean isInCommandLine() {
            return this.mInCommandLine;
        }

        public void setInCommandLine(boolean inCommandLine) {
            this.mInCommandLine = inCommandLine;
        }
    }

    protected static enum Mode {
        BOOLEAN{

            @Override
            public boolean needsExtra() {
                return false;
            }

            @Override
            public Object process(Arg arg, String extra) {
                arg.setCurrentValue((Boolean)arg.getCurrentValue() == false);
                return Accept.ACCEPT_AND_STOP;
            }
        }
        ,
        INTEGER{

            @Override
            public boolean needsExtra() {
                return true;
            }

            @Override
            public Object process(Arg arg, String extra) {
                try {
                    arg.setCurrentValue(Integer.parseInt(extra));
                    return null;
                }
                catch (NumberFormatException e) {
                    return String.format("Failed to parse '%1$s' as an integer: %2$s", extra, e.getMessage());
                }
            }
        }
        ,
        ENUM{

            @Override
            public boolean needsExtra() {
                return true;
            }

            @Override
            public Object process(Arg arg, String extra) {
                String[] values;
                StringBuilder desc = new StringBuilder();
                for (String value : values = (String[])arg.getDefaultValue()) {
                    if (value.equals(extra)) {
                        arg.setCurrentValue(extra);
                        return Accept.ACCEPT_AND_STOP;
                    }
                    if (desc.length() != 0) {
                        desc.append(", ");
                    }
                    desc.append(value);
                }
                return String.format("'%1$s' is not one of %2$s", extra, desc.toString());
            }
        }
        ,
        STRING{

            @Override
            public boolean needsExtra() {
                return true;
            }

            @Override
            public Object process(Arg arg, String extra) {
                arg.setCurrentValue(extra);
                return Accept.ACCEPT_AND_STOP;
            }
        }
        ,
        STRING_ARRAY{

            @Override
            public boolean needsExtra() {
                return true;
            }

            @Override
            public Object process(Arg arg, String extra) {
                if (extra != null) {
                    List<String> a;
                    List<String> v = arg.getCurrentValue();
                    if (v == null) {
                        a = new ArrayList();
                        arg.setCurrentValue(a);
                        v = a;
                    }
                    if (v instanceof List) {
                        a = v;
                        if (extra.equals("--") || !extra.startsWith("-") || extra.startsWith("-") && a.contains("--")) {
                            a.add(extra);
                            return Accept.CONTINUE;
                        }
                        if (a.isEmpty()) {
                            return "No values provided";
                        }
                    }
                }
                return Accept.REJECT_AND_STOP;
            }
        };


        public abstract boolean needsExtra();

        public abstract Object process(Arg var1, String var2);
    }

    protected static enum Accept {
        CONTINUE,
        ACCEPT_AND_STOP,
        REJECT_AND_STOP;

    }
}

