/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.management.ManagementFactory;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class JvmWideVariable<T> {
    private final String group;
    private final String name;
    private static final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName objectName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JvmWideVariable(String group, String name, TypeToken<T> typeToken, T defaultValue) {
        Object clazz2;
        Type type = typeToken.getType();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.collectComponentClasses(type, builder);
        ImmutableSet classes = builder.build();
        for (Object clazz2 : classes) {
            Preconditions.checkArgument((((Class)clazz2).getClassLoader() == null ? 1 : 0) != 0, (String)"Type %s used to define JVM-wide variable %s:%s must be loaded by the bootstrap class loader but is loaded by %s", (Object[])new Object[]{clazz2, group, name, ((Class)clazz2).getClassLoader()});
        }
        this.group = group;
        this.name = name;
        try {
            this.objectName = new ObjectName(ValueWrapper.class.getPackage().getName() + ":type=" + ValueWrapper.class.getSimpleName() + ",group=" + group + ",name=" + name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        boolean variableExists = true;
        clazz2 = server;
        synchronized (clazz2) {
            if (!server.isRegistered(this.objectName)) {
                variableExists = false;
                ValueWrapper<T> objectWrapper = new ValueWrapper<T>();
                objectWrapper.setValue(defaultValue);
                objectWrapper.setType(type);
                try {
                    server.registerMBean(objectWrapper, this.objectName);
                }
                catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (variableExists) {
            Type existingType;
            try {
                existingType = (Type)server.getAttribute(this.objectName, "Type");
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                throw new RuntimeException(e);
            }
            Preconditions.checkArgument((boolean)existingType.equals(type), (String)"Expected type %s but found type %s for JVM-wide variable %s:%s", (Object[])new Object[]{existingType, type, group, name});
        }
    }

    public JvmWideVariable(String group, String name, Class<T> type, T defaultValue) {
        this(group, name, TypeToken.of(type), defaultValue);
    }

    private void collectComponentClasses(Type type, ImmutableSet.Builder<Class<?>> builder) {
        if (type instanceof Class) {
            builder.add((Object)((Class)type));
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.collectComponentClasses(parameterizedType.getRawType(), builder);
            if (parameterizedType.getOwnerType() != null) {
                this.collectComponentClasses(parameterizedType.getOwnerType(), builder);
            }
            for (Type componentType : parameterizedType.getActualTypeArguments()) {
                this.collectComponentClasses(componentType, builder);
            }
        } else if (type instanceof GenericArrayType) {
            this.collectComponentClasses(((GenericArrayType)type).getGenericComponentType(), builder);
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type componentType : wildcardType.getLowerBounds()) {
                this.collectComponentClasses(componentType, builder);
            }
            for (Type componentType : wildcardType.getUpperBounds()) {
                this.collectComponentClasses(componentType, builder);
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " is not yet supported by the JvmWideVariable class");
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        try {
            return (T)server.getAttribute(this.objectName, "Value");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(T value) {
        try {
            server.setAttribute(this.objectName, new Attribute("Value", value));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    void unregister() {
        try {
            server.unregisterMBean(this.objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V doCallableSynchronized(Callable<V> action) throws ExecutionException {
        Object mBean;
        try {
            mBean = server.getAttribute(this.objectName, "ThisInstance");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
        Object object = mBean;
        synchronized (object) {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    public <V> V doSupplierSynchronized(Supplier<V> action) {
        try {
            return (V)this.doCallableSynchronized(() -> action.get());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void doRunnableSynchronized(Runnable action) {
        this.doSupplierSynchronized(() -> {
            action.run();
            return null;
        });
    }

    public static interface ValueWrapperMBean<T> {
        public static final String VALUE_PROPERTY = "Value";
        public static final String TYPE_PROPERTY = "Type";
        public static final String THIS_INSTANCE_PROPERTY = "ThisInstance";

        public T getValue();

        public void setValue(T var1);

        public Type getType();

        public void setType(Type var1);

        public ValueWrapperMBean<T> getThisInstance();
    }

    private static final class ValueWrapper<T>
    implements ValueWrapperMBean<T> {
        private T value;
        private Type type;

        private ValueWrapper() {
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public void setType(Type type) {
            this.type = type;
        }

        @Override
        public ValueWrapperMBean<T> getThisInstance() {
            return this;
        }
    }
}

