/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.DataMerger;
import com.android.ide.common.res2.GeneratedResourceSet;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.res2.SourcelessResourceItem;
import com.android.ide.common.res2.ValueResourceParser2;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceMerger
extends DataMerger<ResourceItem, ResourceFile, ResourceSet> {
    private static final String NODE_MERGED_ITEMS = "mergedItems";
    private int mMinSdk;
    private Set<String> mRejectCache;
    protected final Map<String, Map<String, ResourceItem>> mMergedItems = Maps.newHashMap();

    public ResourceMerger(int minSdk) {
        this.mMinSdk = minSdk;
    }

    @Override
    protected ResourceSet createFromXml(Node node) throws MergingException {
        String fromDependency;
        String generated = NodeUtils.getAttribute(node, "generated");
        ResourceSet set = "true".equals(generated) ? new GeneratedResourceSet("", null) : new ResourceSet("", null);
        ResourceSet newResourceSet = (ResourceSet)set.createFromXml(node);
        String generatedSetName = NodeUtils.getAttribute(node, "generated-set");
        if (generatedSetName != null) {
            for (ResourceSet resourceSet : this.getDataSets()) {
                if (!resourceSet.getConfigName().equals(generatedSetName)) continue;
                newResourceSet.setGeneratedSet(resourceSet);
                break;
            }
        }
        if ("true".equals(fromDependency = NodeUtils.getAttribute(node, "from-dependency"))) {
            newResourceSet.setFromDependency(true);
        }
        return newResourceSet;
    }

    @Override
    protected boolean requiresMerge(String dataItemKey) {
        return dataItemKey.startsWith("declare-styleable/");
    }

    @Override
    protected void mergeItems(String dataItemKey, List<ResourceItem> items, MergeConsumer<ResourceItem> consumer) throws MergingException {
        boolean touched = false;
        boolean removed = true;
        for (ResourceItem item : items) {
            touched |= item.isTouched();
            removed &= item.isRemoved();
        }
        ResourceItem sourceItem = items.get(0);
        String itemName = sourceItem.getName();
        String qualifier = sourceItem.getQualifiers();
        String libraryName = sourceItem.getLibraryName();
        ResourceItem previouslyWrittenItem = this.getMergedItem(qualifier, itemName);
        try {
            if (touched || previouslyWrittenItem == null && !removed) {
                DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element declareStyleableNode = document.createElementNS(null, "declare-styleable");
                Attr nameAttr = document.createAttribute("name");
                nameAttr.setValue(itemName);
                declareStyleableNode.getAttributes().setNamedItem(nameAttr);
                HashSet attrs = Sets.newHashSet();
                for (ResourceItem item : items) {
                    Node oldDeclareStyleable;
                    if (item.isRemoved() || (oldDeclareStyleable = item.getValue()) == null) continue;
                    NodeList children = oldDeclareStyleable.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        String name;
                        NamedNodeMap attributes;
                        Node attrNode = children.item(i);
                        if (attrNode.getNodeType() != 1 || "eat-comment".equals(attrNode.getLocalName()) || (nameAttr = (Attr)(attributes = attrNode.getAttributes()).getNamedItemNS(null, "name")) == null || attrs.contains(name = nameAttr.getNodeValue())) continue;
                        attrs.add(name);
                        Node newAttrNode = NodeUtils.duplicateNode(document, attrNode);
                        declareStyleableNode.appendChild(newAttrNode);
                    }
                }
                MergedResourceItem newItem = new MergedResourceItem(itemName, sourceItem.getType(), qualifier, declareStyleableNode, libraryName);
                if (previouslyWrittenItem == null || !NodeUtils.compareElementNode(newItem.getValue(), previouslyWrittenItem.getValue(), false)) {
                    newItem.setTouched();
                }
                this.addMergedItem(qualifier, newItem);
                consumer.addItem(newItem);
            } else if (previouslyWrittenItem != null) {
                if (removed) {
                    consumer.removeItem(previouslyWrittenItem, null);
                } else {
                    consumer.addItem(previouslyWrittenItem);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).build();
        }
    }

    private ResourceItem getMergedItem(String qualifiers, String name) {
        Map<String, ResourceItem> map = this.mMergedItems.get(qualifiers);
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    @Override
    protected String getAdditionalDataTagName() {
        return NODE_MERGED_ITEMS;
    }

    @Override
    protected void loadAdditionalData(Node mergedItemsNode, boolean incrementalState) throws MergingException {
        if (!incrementalState) {
            return;
        }
        NodeList configurationList = mergedItemsNode.getChildNodes();
        int n2 = configurationList.getLength();
        for (int j = 0; j < n2; ++j) {
            Attr qualifierAttr;
            Node configuration = configurationList.item(j);
            if (configuration.getNodeType() != 1 || !"configuration".equals(configuration.getLocalName()) || (qualifierAttr = (Attr)configuration.getAttributes().getNamedItem("qualifiers")) == null) continue;
            String qualifier = qualifierAttr.getValue();
            NodeList itemList = configuration.getChildNodes();
            int n3 = itemList.getLength();
            for (int k = 0; k < n3; ++k) {
                MergedResourceItem item;
                Node itemNode = itemList.item(k);
                if (itemNode.getNodeType() != 1 || (item = ResourceMerger.getMergedResourceItem(itemNode, qualifier)) == null) continue;
                this.addMergedItem(qualifier, item);
            }
        }
    }

    @Override
    protected void writeAdditionalData(Document document, Node rootNode) {
        Element mergedItemsNode = document.createElement(this.getAdditionalDataTagName());
        rootNode.appendChild(mergedItemsNode);
        for (String qualifier : this.mMergedItems.keySet()) {
            Map<String, ResourceItem> itemMap = this.mMergedItems.get(qualifier);
            Element qualifierNode = document.createElement("configuration");
            NodeUtils.addAttribute(document, qualifierNode, null, "qualifiers", qualifier);
            mergedItemsNode.appendChild(qualifierNode);
            for (ResourceItem item : itemMap.values()) {
                Node adoptedNode = item.getDetailsXml(document);
                if (adoptedNode == null) continue;
                qualifierNode.appendChild(adoptedNode);
            }
        }
    }

    private void addMergedItem(String qualifier, ResourceItem item) {
        HashMap map = this.mMergedItems.get(qualifier);
        if (map == null) {
            map = Maps.newHashMap();
            this.mMergedItems.put(qualifier, map);
        }
        map.put(item.getName(), item);
    }

    static MergedResourceItem getMergedResourceItem(Node node, String qualifiers) throws MergingException {
        ResourceType type = ValueResourceParser2.getType(node, null);
        String name = ValueResourceParser2.getName(node);
        if (name != null && type != null) {
            return new MergedResourceItem(name, type, qualifiers, node, null);
        }
        return null;
    }

    @Override
    public void addDataSet(ResourceSet resourceSet) {
        super.addDataSet(resourceSet);
    }

    @Override
    public void mergeData(MergeConsumer<ResourceItem> consumer, boolean doCleanUp) throws MergingException {
        this.clearFilterCache();
        super.mergeData(consumer, doCleanUp);
    }

    @Override
    protected boolean filterAccept(ResourceItem dataItem) {
        if (this.mRejectCache == null) {
            this.buildCache();
        }
        boolean accepted = !this.mRejectCache.contains(dataItem.getKey());
        return accepted;
    }

    private void buildCache() {
        this.mRejectCache = Sets.newHashSet();
        HashBasedTable itemCache = HashBasedTable.create();
        HashSet acceptCache = Sets.newHashSet();
        for (ResourceSet resourceSet : this.getDataSets()) {
            ListMultimap map = resourceSet.getDataMap();
            for (ResourceItem resourceItem : map.values()) {
                FolderConfiguration qualifierWithoutSdk;
                int resourceMinSdk;
                String resourceKey = resourceItem.getKey();
                if (acceptCache.contains(resourceKey) || this.mRejectCache.contains(resourceKey)) continue;
                if (resourceItem.getSourceType() != DataFile.FileType.SINGLE_FILE) {
                    acceptCache.add(resourceKey);
                    continue;
                }
                FolderConfiguration config = resourceItem.getConfiguration();
                if (!ResourceQualifier.isValid(config.getVersionQualifier())) {
                    resourceMinSdk = 0;
                    qualifierWithoutSdk = config;
                } else {
                    resourceMinSdk = config.getVersionQualifier().getVersion();
                    qualifierWithoutSdk = FolderConfiguration.copyOf(config);
                    qualifierWithoutSdk.removeQualifier(qualifierWithoutSdk.getVersionQualifier());
                }
                if (resourceMinSdk > this.mMinSdk) {
                    acceptCache.add(resourceKey);
                    continue;
                }
                String resourceCacheId = resourceItem.getType().getName() + "-" + resourceItem.getName();
                Pair selectedResource = (Pair)itemCache.get((Object)resourceCacheId, (Object)qualifierWithoutSdk);
                if (selectedResource == null) {
                    selectedResource = Pair.of((Object)resourceMinSdk, (Object)resourceItem);
                    itemCache.put((Object)resourceCacheId, (Object)qualifierWithoutSdk, (Object)selectedResource);
                    acceptCache.add(resourceKey);
                    continue;
                }
                if ((Integer)selectedResource.getFirst() > resourceMinSdk) {
                    this.mRejectCache.add(resourceKey);
                    continue;
                }
                String removeKey = ((ResourceItem)selectedResource.getSecond()).getKey();
                acceptCache.remove(removeKey);
                this.mRejectCache.add(removeKey);
                acceptCache.add(resourceKey);
                selectedResource = Pair.of((Object)resourceMinSdk, (Object)resourceItem);
                itemCache.put((Object)resourceCacheId, (Object)qualifierWithoutSdk, (Object)selectedResource);
            }
        }
    }

    private void clearFilterCache() {
        this.mRejectCache = null;
    }

    private static class MergedResourceItem
    extends SourcelessResourceItem {
        private final String mQualifiers;

        public MergedResourceItem(String name, ResourceType type, String qualifiers, Node value, String libraryName) {
            super(name, type, value, libraryName);
            this.mQualifiers = qualifiers;
        }

        @Override
        public String getQualifiers() {
            return this.mQualifiers;
        }

        @Override
        public DataFile.FileType getSourceType() {
            return DataFile.FileType.XML_VALUES;
        }
    }
}

