/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.ide.common.rendering.FilteredClassLoader;
import com.android.ide.common.rendering.api.Bridge;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.sdk.LoadStatus;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LayoutLibrary {
    public static final String CLASS_BRIDGE = "com.android.layoutlib.bridge.Bridge";
    public static final String FN_ICU_JAR = "icu4j.jar";
    private final Bridge mBridge;
    private final LoadStatus mStatus;
    private final String mLoadMessage;
    private final ClassLoader mClassLoader;
    private Method mViewGetParentMethod;
    private Method mViewGetBaselineMethod;
    private Method mViewParentIndexOfChildMethod;
    private Class<?> mMarginLayoutParamClass;
    private Field mLeftMarginField;
    private Field mTopMarginField;
    private Field mRightMarginField;
    private Field mBottomMarginField;

    public LoadStatus getStatus() {
        return this.mStatus;
    }

    public String getLoadMessage() {
        return this.mLoadMessage;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public static LayoutLibrary load(Bridge bridge, ClassLoader classLoader) {
        return new LayoutLibrary(bridge, classLoader, LoadStatus.LOADED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImmutableSet<String> getJarClasses(URL[] urls) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (URL url : urls) {
            ZipInputStream zipStream = null;
            try {
                zipStream = new ZipInputStream(url.openStream());
                ZipEntry entry = zipStream.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name != null && name.endsWith(".class")) {
                        builder.add((Object)name.substring(0, name.length() - ".class".length()).replace("/", "."));
                    }
                    entry = zipStream.getNextEntry();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (zipStream != null) {
                    try {
                        zipStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return builder.build();
    }

    public static LayoutLibrary load(String layoutLibJarOsPath, ILogger log, String toolName) {
        ClassLoader classLoader;
        Bridge bridge;
        String message;
        LoadStatus status;
        block13: {
            status = LoadStatus.LOADING;
            message = null;
            bridge = null;
            classLoader = null;
            try {
                File f = new File(layoutLibJarOsPath);
                if (!f.isFile()) {
                    if (log != null) {
                        log.error(null, "layoutlib.jar is missing!", new Object[0]);
                    }
                } else {
                    Object bridgeObject;
                    Constructor<?> constructor;
                    URL[] urls;
                    File icu4j = new File(f.getParent(), FN_ICU_JAR);
                    if (icu4j.isFile()) {
                        urls = new URL[2];
                        urls[1] = SdkUtils.fileToUrl((File)icu4j);
                    } else {
                        urls = new URL[]{SdkUtils.fileToUrl((File)f)};
                    }
                    Set jarClasses = Sets.filter(LayoutLibrary.getJarClasses(urls), input -> !input.startsWith("org.xmlpull.v1") && !input.contains("$"));
                    classLoader = new FilteredClassLoader(LayoutLibrary.class.getClassLoader(), jarClasses);
                    classLoader = new URLClassLoader(urls, classLoader);
                    Class<?> clazz = classLoader.loadClass(CLASS_BRIDGE);
                    if (clazz != null && (constructor = clazz.getConstructor(new Class[0])) != null && (bridgeObject = constructor.newInstance(new Object[0])) instanceof Bridge) {
                        bridge = (Bridge)bridgeObject;
                    }
                    if (bridge == null) {
                        status = LoadStatus.FAILED;
                        message = "Failed to load com.android.layoutlib.bridge.Bridge";
                        if (log != null) {
                            log.error(null, "Failed to load com.android.layoutlib.bridge.Bridge from " + layoutLibJarOsPath, new Object[0]);
                        }
                    } else {
                        status = LoadStatus.LOADED;
                        int api = bridge.getApiLevel();
                        if (api > 17) {
                            status = LoadStatus.FAILED;
                            message = String.format("This version of the rendering library is more recent than your version of %1$s. Please update %1$s", toolName);
                        }
                    }
                }
            }
            catch (Throwable t) {
                status = LoadStatus.FAILED;
                Throwable cause = t;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                message = "Failed to load the LayoutLib: " + cause.getMessage();
                if (log == null) break block13;
                log.error(t, message, new Object[0]);
            }
        }
        return new LayoutLibrary(bridge, classLoader, status, message);
    }

    private LayoutLibrary(Bridge bridge, ClassLoader classLoader, LoadStatus status, String message) {
        this.mBridge = bridge;
        this.mClassLoader = classLoader;
        this.mStatus = status;
        this.mLoadMessage = message;
    }

    public int getApiLevel() {
        if (this.mBridge != null) {
            return this.mBridge.getApiLevel();
        }
        return 0;
    }

    public int getRevision() {
        if (this.mBridge != null) {
            return this.mBridge.getRevision();
        }
        return 0;
    }

    @Deprecated
    public boolean supports(Capability capability) {
        return this.supports(capability.ordinal());
    }

    public boolean supports(int capability) {
        if (this.mBridge != null) {
            if (this.mBridge.getApiLevel() > 12) {
                return this.mBridge.supports(capability);
            }
            return capability <= 13 && this.mBridge.getCapabilities().contains(Capability.values()[capability]);
        }
        return false;
    }

    public boolean init(Map<String, String> platformProperties, File fontLocation, Map<String, Map<String, Integer>> enumValueMap, LayoutLog log) {
        if (this.mBridge != null) {
            return this.mBridge.init(platformProperties, fontLocation, enumValueMap, log);
        }
        return false;
    }

    public boolean dispose() {
        if (this.mBridge != null) {
            return this.mBridge.dispose();
        }
        return true;
    }

    public RenderSession createSession(SessionParams params) {
        if (this.mBridge != null) {
            List infoList;
            RenderSession session = this.mBridge.createSession(params);
            if (params.getExtendedViewInfoMode() && !this.supports(9) && (infoList = session.getRootViews()) != null) {
                for (ViewInfo info : infoList) {
                    this.addExtendedViewInfo(info);
                }
            }
            return session;
        }
        return null;
    }

    public Result renderDrawable(DrawableParams params) {
        if (this.mBridge != null) {
            return this.mBridge.renderDrawable(params);
        }
        return Result.Status.NOT_IMPLEMENTED.createResult();
    }

    public void clearCaches(Object projectKey) {
        if (this.mBridge != null) {
            this.mBridge.clearCaches(projectKey);
        }
    }

    public Result getViewParent(Object viewObject) {
        Result r;
        if (this.mBridge != null && (r = this.mBridge.getViewParent(viewObject)).isSuccess()) {
            return r;
        }
        return this.getViewParentWithReflection(viewObject);
    }

    public Result getViewIndex(Object viewObject) {
        Result r;
        if (this.mBridge != null && (r = this.mBridge.getViewIndex(viewObject)).isSuccess()) {
            return r;
        }
        return this.getViewIndexReflection(viewObject);
    }

    public boolean isRtl(String locale) {
        return this.supports(11) && this.mBridge != null && this.mBridge.isRtl(locale);
    }

    private Result getViewParentWithReflection(Object viewObject) {
        try {
            if (this.mViewGetParentMethod == null) {
                Class<?> viewClass = Class.forName("android.view.View");
                this.mViewGetParentMethod = viewClass.getMethod("getParent", new Class[0]);
            }
            return Result.Status.SUCCESS.createResult(this.mViewGetParentMethod.invoke(viewObject, new Object[0]));
        }
        catch (Exception e) {
            return Result.Status.ERROR_REFLECTION.createResult(null, (Throwable)e);
        }
    }

    private Result getViewIndexReflection(Object viewObject) {
        try {
            Class<?> viewClass = Class.forName("android.view.View");
            if (this.mViewGetParentMethod == null) {
                this.mViewGetParentMethod = viewClass.getMethod("getParent", new Class[0]);
            }
            Object parentObject = this.mViewGetParentMethod.invoke(viewObject, new Object[0]);
            if (this.mViewParentIndexOfChildMethod == null) {
                Class<?> viewParentClass = Class.forName("android.view.ViewParent");
                this.mViewParentIndexOfChildMethod = viewParentClass.getMethod("indexOfChild", viewClass);
            }
            return Result.Status.SUCCESS.createResult(this.mViewParentIndexOfChildMethod.invoke(parentObject, viewObject));
        }
        catch (Exception e) {
            return Result.Status.ERROR_REFLECTION.createResult(null, (Throwable)e);
        }
    }

    private void addExtendedViewInfo(ViewInfo info) {
        this.computeExtendedViewInfo(info);
        List children = info.getChildren();
        for (ViewInfo child : children) {
            this.addExtendedViewInfo(child);
        }
    }

    private void computeExtendedViewInfo(ViewInfo info) {
        Object viewObject = info.getViewObject();
        Object params = info.getLayoutParamsObject();
        int baseLine = this.getViewBaselineReflection(viewObject);
        int leftMargin = 0;
        int topMargin = 0;
        int rightMargin = 0;
        int bottomMargin = 0;
        try {
            if (this.mMarginLayoutParamClass == null) {
                this.mMarginLayoutParamClass = Class.forName("android.view.ViewGroup$MarginLayoutParams");
                this.mLeftMarginField = this.mMarginLayoutParamClass.getField("leftMargin");
                this.mTopMarginField = this.mMarginLayoutParamClass.getField("topMargin");
                this.mRightMarginField = this.mMarginLayoutParamClass.getField("rightMargin");
                this.mBottomMarginField = this.mMarginLayoutParamClass.getField("bottomMargin");
            }
            if (this.mMarginLayoutParamClass.isAssignableFrom(params.getClass())) {
                leftMargin = (Integer)this.mLeftMarginField.get(params);
                topMargin = (Integer)this.mTopMarginField.get(params);
                rightMargin = (Integer)this.mRightMarginField.get(params);
                bottomMargin = (Integer)this.mBottomMarginField.get(params);
            }
        }
        catch (Exception e) {
            leftMargin = Integer.MIN_VALUE;
            topMargin = Integer.MIN_VALUE;
            rightMargin = Integer.MIN_VALUE;
            bottomMargin = Integer.MIN_VALUE;
        }
        info.setExtendedInfo(baseLine, leftMargin, topMargin, rightMargin, bottomMargin);
    }

    private int getViewBaselineReflection(Object viewObject) {
        try {
            Object result;
            if (this.mViewGetBaselineMethod == null) {
                Class<?> viewClass = Class.forName("android.view.View");
                this.mViewGetBaselineMethod = viewClass.getMethod("getBaseline", new Class[0]);
            }
            if ((result = this.mViewGetBaselineMethod.invoke(viewObject, new Object[0])) instanceof Integer) {
                return (Integer)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MIN_VALUE;
    }

    protected LayoutLibrary() {
        this.mBridge = null;
        this.mClassLoader = null;
        this.mStatus = null;
        this.mLoadMessage = null;
    }
}

