/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.ResourceType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ValueResourceParser
extends DefaultHandler {
    private boolean inResources;
    private int mDepth;
    private ResourceValue mCurrentValue;
    private ArrayResourceValue mArrayResourceValue;
    private StyleResourceValue mCurrentStyle;
    private DeclareStyleableResourceValue mCurrentDeclareStyleable;
    private AttrResourceValue mCurrentAttr;
    private IValueResourceRepository mRepository;
    private final boolean mIsFramework;
    private final String mLibraryName;

    public ValueResourceParser(IValueResourceRepository repository, boolean isFramework, String libraryName) {
        this.mRepository = repository;
        this.mIsFramework = isFramework;
        this.mLibraryName = libraryName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.mCurrentValue != null) {
            String value = this.mCurrentValue.getValue();
            value = value == null ? "" : ValueXmlHelper.unescapeResourceString(value, false, true);
            this.mCurrentValue.setValue(value);
        }
        if (this.inResources && qName.equals("resources")) {
            this.inResources = false;
        } else if (this.mDepth == 2) {
            this.mCurrentValue = null;
            this.mCurrentStyle = null;
            this.mCurrentDeclareStyleable = null;
            this.mCurrentAttr = null;
            this.mArrayResourceValue = null;
        } else if (this.mDepth == 3) {
            if (this.mArrayResourceValue != null && this.mCurrentValue != null) {
                this.mArrayResourceValue.addElement(this.mCurrentValue.getValue());
            }
            this.mCurrentValue = null;
            if (this.mCurrentDeclareStyleable != null) {
                this.mCurrentAttr = null;
            }
        }
        --this.mDepth;
        super.endElement(uri, localName, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            ++this.mDepth;
            if (!this.inResources && this.mDepth == 1) {
                if (qName.equals("resources")) {
                    this.inResources = true;
                }
            } else if (this.mDepth == 2 && this.inResources) {
                String name;
                ResourceType type = ValueResourceParser.getType(qName, attributes);
                if (type != null && (name = attributes.getValue("name")) != null) {
                    switch (type) {
                        case STYLE: {
                            String parent = attributes.getValue("parent");
                            this.mCurrentStyle = new StyleResourceValue(type, name, parent, this.mIsFramework, this.mLibraryName);
                            this.mRepository.addResourceValue((ResourceValue)this.mCurrentStyle);
                            break;
                        }
                        case DECLARE_STYLEABLE: {
                            this.mCurrentDeclareStyleable = new DeclareStyleableResourceValue(type, name, this.mIsFramework, this.mLibraryName);
                            this.mRepository.addResourceValue((ResourceValue)this.mCurrentDeclareStyleable);
                            break;
                        }
                        case ATTR: {
                            this.mCurrentAttr = new AttrResourceValue(type, name, this.mIsFramework, this.mLibraryName);
                            this.mRepository.addResourceValue((ResourceValue)this.mCurrentAttr);
                            break;
                        }
                        case ARRAY: {
                            this.mArrayResourceValue = new ArrayResourceValue(name, this.mIsFramework, this.mLibraryName);
                            this.mRepository.addResourceValue((ResourceValue)this.mArrayResourceValue);
                            break;
                        }
                        default: {
                            this.mCurrentValue = new ResourceValue(type, name, this.mIsFramework, this.mLibraryName);
                            this.mRepository.addResourceValue(this.mCurrentValue);
                        }
                    }
                }
            } else if (this.mDepth == 3) {
                String name = attributes.getValue("name");
                if (name != null) {
                    if (this.mCurrentStyle != null) {
                        boolean isFrameworkAttr = this.mIsFramework;
                        if (name.startsWith("android:")) {
                            name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                            isFrameworkAttr = true;
                        }
                        this.mCurrentValue = new ItemResourceValue(name, isFrameworkAttr, this.mIsFramework, this.mLibraryName);
                        this.mCurrentStyle.addItem((ItemResourceValue)this.mCurrentValue);
                    } else if (this.mCurrentDeclareStyleable != null) {
                        boolean isFramework = this.mIsFramework;
                        if (name.startsWith("android:")) {
                            name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                            isFramework = true;
                        }
                        this.mCurrentAttr = new AttrResourceValue(ResourceType.ATTR, name, isFramework, this.mLibraryName);
                        this.mCurrentDeclareStyleable.addValue(this.mCurrentAttr);
                        this.mRepository.addResourceValue((ResourceValue)this.mCurrentAttr);
                    } else if (this.mCurrentAttr != null) {
                        String value = attributes.getValue("value");
                        try {
                            this.mCurrentAttr.addValue(name, Integer.valueOf((int)Long.decode(value).longValue()));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (this.mArrayResourceValue != null) {
                    this.mCurrentValue = new ResourceValue(null, null, this.mIsFramework, this.mLibraryName);
                }
            } else if (this.mDepth == 4 && this.mCurrentAttr != null) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                try {
                    this.mCurrentAttr.addValue(name, Integer.valueOf((int)Long.decode(value).longValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private static ResourceType getType(String qName, Attributes attributes) {
        String typeValue = "item".equals(qName) ? attributes.getValue("type") : qName;
        return ResourceType.getEnum((String)typeValue);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mCurrentValue != null) {
            String value = this.mCurrentValue.getValue();
            if (value == null) {
                this.mCurrentValue.setValue(new String(ch, start, length));
            } else {
                this.mCurrentValue.setValue(value + new String(ch, start, length));
            }
        }
    }

    public static interface IValueResourceRepository {
        public void addResourceValue(ResourceValue var1);

        public boolean hasResourceValue(ResourceType var1, String var2);
    }
}

