/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.AssetFile;
import com.android.ide.common.res2.AssetItem;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergeWriter;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;

public class MergedAssetWriter
extends MergeWriter<AssetItem> {
    public MergedAssetWriter(File rootFolder) {
        super(rootFolder);
    }

    @Override
    public void addItem(AssetItem item) throws MergeConsumer.ConsumerException {
        if (item.isTouched()) {
            this.getExecutor().execute(() -> {
                AssetFile assetFile = (AssetFile)Preconditions.checkNotNull(item.getSource());
                Path fromFile = assetFile.getFile().toPath();
                Path toFile = new File(this.getRootFolder(), item.getKey().replace('/', File.separatorChar)).toPath();
                Files.createDirectories(toFile.getParent(), new FileAttribute[0]);
                if (item.shouldBeUnGzipped()) {
                    try (GZIPInputStream gzipInputStream = new GZIPInputStream(new BufferedInputStream(Files.newInputStream(fromFile, new OpenOption[0])));){
                        Files.copy(gzipInputStream, toFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    Files.copy(fromFile, toFile, StandardCopyOption.REPLACE_EXISTING);
                }
                return null;
            });
        }
    }

    @Override
    public void removeItem(AssetItem removedItem, AssetItem replacedBy) throws MergeConsumer.ConsumerException {
        if (replacedBy == null) {
            File removedFile = new File(this.getRootFolder(), removedItem.getName());
            removedFile.delete();
        }
    }

    @Override
    public boolean ignoreItemInMerge(AssetItem item) {
        return false;
    }
}

