/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.sources;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemoteListSourceProvider;
import com.android.repository.api.RemoteSource;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.SchemaModule;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.ls.LSResourceResolver;

public class RemoteListSourceProviderImpl
extends RemoteListSourceProvider {
    private static SchemaModule<?> sAddonListModule = new SchemaModule(RemoteListSourceProviderImpl.class.getPackage().getName() + ".generated.v%d.ObjectFactory", "repo-sites-common-%d.xsd", RepoManager.class);
    private final String mUrl;
    private final Map<Class<? extends RepositorySource>, Collection<SchemaModule<?>>> mAllowedModules;
    private final SchemaModule mSourceListModule;
    private List<RepositorySource> mSources;

    public RemoteListSourceProviderImpl(String url, SchemaModule sourceListModule, Map<Class<? extends RepositorySource>, Collection<SchemaModule<?>>> permittedSchemaModules) throws URISyntaxException {
        this.mUrl = url;
        this.mAllowedModules = permittedSchemaModules;
        this.mSourceListModule = sourceListModule;
    }

    @Override
    public List<RepositorySource> getSources(Downloader downloader, ProgressIndicator progress, boolean forceRefresh) {
        if (downloader == null) {
            throw new IllegalArgumentException("downloader must not be null");
        }
        if (this.mSources != null && !forceRefresh) {
            return this.mSources;
        }
        InputStream xml = null;
        URL url = null;
        SchemaModule sourceModule = this.mSourceListModule == null ? sAddonListModule : this.mSourceListModule;
        for (int version = sourceModule.getNamespaceVersionMap().size(); xml == null && version > 0; --version) {
            String urlStr = String.format(this.mUrl, version);
            try {
                url = new URL(urlStr);
                xml = downloader.downloadAndStream(url, progress);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (UnknownHostException e) {
                progress.logWarning("Failed to connect to host: " + urlStr);
                continue;
            }
            catch (MalformedURLException e) {
                progress.logWarning("Invalid URL: " + urlStr);
                continue;
            }
            catch (IOException e) {
                progress.logInfo("IOException: " + urlStr);
                progress.logInfo(e.toString());
            }
        }
        if (xml != null) {
            List<RepositorySource> result = this.parse(xml, progress, url);
            this.mSources = result;
            return this.mSources;
        }
        progress.logWarning("Failed to download any source lists!");
        return ImmutableList.of();
    }

    private List<RepositorySource> parse(InputStream xml, ProgressIndicator progress, URL url) {
        HashSet schemas = Sets.newHashSet((Object[])new SchemaModule[]{sAddonListModule});
        if (this.mSourceListModule != null) {
            schemas.add(this.mSourceListModule);
        }
        LSResourceResolver resourceResolver = SchemaModuleUtil.createResourceResolver(schemas, progress);
        SiteList sl = null;
        try {
            sl = (SiteList)SchemaModuleUtil.unmarshal(xml, schemas, resourceResolver, true, progress);
        }
        catch (JAXBException e) {
            progress.logWarning("Failed to parse source list at " + url);
        }
        ArrayList result = Lists.newArrayList();
        if (sl != null) {
            for (RemoteSource s : sl.getSite()) {
                for (Class<? extends RepositorySource> c : this.mAllowedModules.keySet()) {
                    if (!c.isInstance(s)) continue;
                    s.setPermittedSchemaModules(this.mAllowedModules.get(c));
                }
                String urlStr = s.getUrl();
                try {
                    URL fullUrl = new URL(url, urlStr);
                    s.setUrl(fullUrl.toExternalForm());
                }
                catch (MalformedURLException e) {
                    progress.logWarning("Failed to parse URL in remote source list", e);
                }
                s.setProvider(this);
                result.add(s);
            }
        }
        return result;
    }

    @Override
    public boolean addSource(RepositorySource source) {
        throw new UnsupportedOperationException("Can't add to RemoteListSourceProvider");
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public void save(ProgressIndicator progress) {
    }

    @Override
    public boolean removeSource(RepositorySource source) {
        throw new UnsupportedOperationException("Can't add to RemoteListSourceProvider");
    }

    @XmlTransient
    public static class SiteList {
        public List<RemoteSource> getSite() {
            return this.getAddonSiteOrSysImgSite();
        }

        protected List<Object> getAddonSiteOrSysImgSite() {
            return this.getAddonSite();
        }

        protected List<RemoteSource> getAddonSite() {
            throw new UnsupportedOperationException();
        }
    }
}

