/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.downloader;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LocalFileAwareDownloader
implements Downloader {
    private final Downloader mDelegate;

    public LocalFileAwareDownloader(Downloader delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public InputStream downloadAndStream(URL url, ProgressIndicator indicator) throws IOException {
        if ("file".equals(url.getProtocol())) {
            return url.openStream();
        }
        return this.mDelegate.downloadAndStream(url, indicator);
    }

    @Override
    public File downloadFully(URL url, ProgressIndicator indicator) throws IOException {
        if ("file".equals(url.getProtocol())) {
            File tempFile = File.createTempFile(LocalFileAwareDownloader.class.getName(), null);
            File source = new File(url.getFile());
            Files.copy((File)source, (File)tempFile);
        }
        return this.mDelegate.downloadFully(url, indicator);
    }

    @Override
    public void downloadFully(URL url, File target, String checksum, ProgressIndicator indicator) throws IOException {
        if ("file".equals(url.getProtocol())) {
            File source = new File(url.getFile());
            Files.createParentDirs((File)target);
            Files.copy((File)source, (File)target);
            return;
        }
        this.mDelegate.downloadFully(url, target, checksum, indicator);
    }
}

