/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.util;

import com.android.repository.Revision;
import com.android.repository.api.Dependency;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.RevisionType;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.io.FileOp;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class InstallerUtil {
    public static final String PENDING_PACKAGE_XML_FN = "package.xml.pending";
    public static final String INSTALLER_DIR_FN = ".installer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File in, File out, FileOp fop, long expectedSize, ProgressIndicator progress) throws IOException {
        if (!fop.exists(out) || !fop.isDirectory(out)) {
            throw new IllegalArgumentException("out must exist and be a directory.");
        }
        in = fop.ensureRealFile(in);
        progress.setText("Unzipping...");
        ZipFile zipFile = new ZipFile(in);
        try {
            Enumeration entries = zipFile.getEntries();
            progress.setFraction(0.0);
            while (entries.hasMoreElements()) {
                int mode;
                OutputStream unzippedOutput;
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String name = entry.getName();
                File entryFile = new File(out, name);
                progress.setSecondaryText(name);
                if (entry.isUnixSymlink()) {
                    ByteArrayOutputStream targetByteStream = new ByteArrayOutputStream();
                    InstallerUtil.readZipEntry(zipFile, entry, targetByteStream, expectedSize, progress);
                    Path linkPath = fop.toPath(entryFile);
                    Path linkTarget = fop.toPath(new File(targetByteStream.toString()));
                    Files.createSymbolicLink(linkPath, linkTarget, new FileAttribute[0]);
                    continue;
                }
                if (entry.isDirectory()) {
                    if (fop.exists(entryFile) || fop.mkdirs(entryFile)) continue;
                    progress.logWarning("failed to mkdirs " + entryFile);
                    continue;
                }
                if (!fop.exists(entryFile)) {
                    File parent = entryFile.getParentFile();
                    if (parent != null && !fop.exists(parent)) {
                        fop.mkdirs(parent);
                    }
                    if (!fop.createNewFile(entryFile)) {
                        throw new IOException("Failed to create file " + entryFile);
                    }
                }
                if (InstallerUtil.readZipEntry(zipFile, entry, unzippedOutput = fop.newFileOutputStream(entryFile), expectedSize, progress)) {
                    return;
                }
                if (fop.isWindows() || ((mode = entry.getUnixMode()) & 0x49) == 0) continue;
                try {
                    fop.setExecutablePermission(entryFile);
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            ZipFile.closeQuietly((ZipFile)zipFile);
        }
    }

    private static boolean readZipEntry(ZipFile zipFile, ZipArchiveEntry entry, OutputStream dest, long expectedSize, ProgressIndicator progress) throws IOException {
        byte[] buf = new byte[8192];
        double fraction = progress.getFraction();
        try (BufferedOutputStream bufferedDest = new BufferedOutputStream(dest);
             BufferedInputStream s = new BufferedInputStream(zipFile.getInputStream(entry));){
            int size;
            while ((size = ((InputStream)s).read(buf)) > -1) {
                bufferedDest.write(buf, 0, size);
                progress.setFraction(fraction += (double)entry.getCompressedSize() / (double)expectedSize * ((double)size / (double)entry.getSize()));
                if (!progress.isCanceled()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static void writePendingPackageXml(RepoPackage p, File packageRoot, RepoManager manager, FileOp fop, ProgressIndicator progress) throws IOException {
        if (!fop.exists(packageRoot) || !fop.isDirectory(packageRoot)) {
            throw new IllegalArgumentException("packageRoot must exist and be a directory.");
        }
        CommonFactory factory = p.createFactory();
        Repository repo = factory.createRepositoryType();
        License license = p.getLicense();
        if (license != null) {
            repo.addLicense(license);
        }
        p.asMarshallable().addTo(repo);
        File packageXml = new File(packageRoot, PENDING_PACKAGE_XML_FN);
        InstallerUtil.writeRepoXml(manager, repo, packageXml, fop, progress);
    }

    public static Repository readPendingPackageXml(File containingDir, RepoManager manager, FileOp fop, ProgressIndicator progress) throws IOException {
        Repository repo;
        try {
            File xmlFile = new File(containingDir, PENDING_PACKAGE_XML_FN);
            if (!fop.exists(xmlFile)) {
                return null;
            }
            repo = (Repository)SchemaModuleUtil.unmarshal(fop.newFileInputStream(xmlFile), manager.getSchemaModules(), manager.getResourceResolver(progress), false, progress);
        }
        catch (JAXBException e) {
            throw new IOException("Failed to parse pending package xml", e);
        }
        return repo;
    }

    public static void writePackageXml(RemotePackage p, File packageRoot, RepoManager manager, FileOp fop, ProgressIndicator progress) throws IOException {
        if (!fop.exists(packageRoot) || !fop.isDirectory(packageRoot)) {
            throw new IllegalArgumentException("packageRoot must exist and be a directory.");
        }
        CommonFactory factory = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
        Repository repo = factory.createRepositoryType();
        License l = p.getLicense();
        if (l != null) {
            repo.addLicense(l);
        }
        LocalPackageImpl impl = LocalPackageImpl.create(p);
        repo.setLocalPackage(impl);
        File packageXml = new File(packageRoot, "package.xml");
        InstallerUtil.writeRepoXml(manager, repo, packageXml, fop, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRepoXml(RepoManager manager, Repository repo, File packageXml, FileOp fop, ProgressIndicator progress) throws IOException {
        JAXBElement<Repository> element = ((CommonFactory)RepoManager.getCommonModule().createLatestFactory()).generateRepository(repo);
        try (OutputStream fos = fop.newFileOutputStream(packageXml);){
            SchemaModuleUtil.marshal(element, manager.getSchemaModules(), fos, manager.getResourceResolver(progress), progress);
        }
    }

    public static URL resolveCompleteArchiveUrl(RemotePackage p, ProgressIndicator progress) {
        Archive arch = p.getArchive();
        if (arch == null) {
            return null;
        }
        String urlStr = arch.getComplete().getUrl();
        return InstallerUtil.resolveUrl(urlStr, p, progress);
    }

    public static URL resolveUrl(String urlStr, RemotePackage p, ProgressIndicator progress) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            try {
                String sourceUrl = p.getSource().getUrl();
                if (!sourceUrl.endsWith("/")) {
                    sourceUrl = sourceUrl.substring(0, sourceUrl.lastIndexOf(47) + 1);
                }
                urlStr = sourceUrl + urlStr;
                url = new URL(urlStr);
            }
            catch (MalformedURLException e2) {
                progress.logWarning("Failed to parse url: " + urlStr);
                return null;
            }
        }
        return url;
    }

    public static List<RemotePackage> computeRequiredPackages(Collection<RemotePackage> requests, RepositoryPackages packages, ProgressIndicator logger) {
        HashSet requiredPackages = Sets.newHashSet();
        Map<String, UpdatablePackage> consolidatedPackages = packages.getConsolidatedPkgs();
        HashSet seen = Sets.newHashSet();
        HashMultimap allDependencies = HashMultimap.create();
        HashSet roots = Sets.newHashSet();
        LinkedList current = Lists.newLinkedList();
        for (RemotePackage request : requests) {
            UpdatablePackage updatable = consolidatedPackages.get(request.getPath());
            if (updatable == null) {
                logger.logWarning(String.format("No package with key %s found!", request.getPath()));
                return null;
            }
            if (updatable.hasLocal() && !updatable.isUpdate()) continue;
            current.add(request);
            roots.add(request);
            requiredPackages.add(request);
            seen.add(request.getPath());
        }
        while (!current.isEmpty()) {
            RemotePackage currentPackage = (RemotePackage)current.remove();
            Collection<Dependency> currentDependencies = currentPackage.getAllDependencies();
            for (Dependency d : currentDependencies) {
                String dependencyPath = d.getPath();
                UpdatablePackage updatableDependency = consolidatedPackages.get(dependencyPath);
                if (updatableDependency == null) {
                    logger.logWarning(String.format("Dependant package with key %s not found!", dependencyPath));
                    return null;
                }
                LocalPackage localDependency = updatableDependency.getLocal();
                Revision requiredMinRevision = null;
                RevisionType r = d.getMinRevision();
                if (r != null) {
                    requiredMinRevision = r.toRevision();
                }
                if (localDependency != null && (requiredMinRevision == null || requiredMinRevision.compareTo(localDependency.getVersion()) <= 0)) continue;
                if (seen.contains(dependencyPath)) {
                    allDependencies.put((Object)dependencyPath, (Object)d);
                    continue;
                }
                seen.add(dependencyPath);
                RemotePackage remoteDependency = updatableDependency.getRemote();
                if (remoteDependency == null || requiredMinRevision != null && requiredMinRevision.compareTo(remoteDependency.getVersion()) > 0) {
                    logger.logWarning(String.format("Package \"%1$s\" with revision at least %2$s not available.", updatableDependency.getRepresentative().getDisplayName(), requiredMinRevision));
                    return null;
                }
                requiredPackages.add(remoteDependency);
                allDependencies.put((Object)dependencyPath, (Object)d);
                current.add(remoteDependency);
                roots.remove(remoteDependency);
            }
        }
        ArrayList result = Lists.newArrayList();
        while (!roots.isEmpty()) {
            RemotePackage root = (RemotePackage)roots.iterator().next();
            roots.remove(root);
            result.add(root);
            for (Dependency d : root.getAllDependencies()) {
                Collection nodeDeps = allDependencies.get((Object)d.getPath());
                if (nodeDeps.size() == 1) {
                    UpdatablePackage newRoot = consolidatedPackages.get(d.getPath());
                    if (newRoot == null) {
                        logger.logWarning(String.format("Package with key %s not found!", d.getPath()));
                        return null;
                    }
                    roots.add(newRoot.getRemote());
                }
                nodeDeps.remove(d);
            }
        }
        if (result.size() != requiredPackages.size()) {
            logger.logInfo("Failed to sort dependencies, returning partially-sorted list.");
            for (RemotePackage p : result) {
                requiredPackages.remove(p);
            }
            result.addAll(requiredPackages);
        }
        return Lists.reverse((List)result);
    }

    public static boolean checkValidPath(File path, RepoManager manager, ProgressIndicator progress) {
        try {
            String check = path.getCanonicalPath() + File.separator;
            for (LocalPackage p : manager.getPackages().getLocalPackages().values()) {
                String existing = p.getLocation().getCanonicalPath() + File.separator;
                if (existing.equals(check)) continue;
                boolean childExists = existing.startsWith(check);
                boolean parentExists = check.startsWith(existing);
                if (!childExists && !parentExists) continue;
                StringBuilder message = new StringBuilder();
                message.append("Trying to install into ").append(check).append(" but package \"").append(p.getDisplayName()).append("\" already exists at ").append(existing).append(". It must be deleted or moved away before installing into a ").append(childExists ? "parent" : "child").append(" directory.");
                progress.logWarning(message.toString());
                return false;
            }
        }
        catch (IOException e) {
            progress.logWarning("Error while trying to check install path validity", e);
            return false;
        }
        return true;
    }
}

