/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.io.FileOp;
import com.google.common.base.Objects;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class License {
    static final String LICENSE_DIR = "licenses";

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getValue();

    public abstract void setValue(String var1);

    public String getType() {
        return null;
    }

    public void setType(String type) {
    }

    public String getLicenseHash() {
        return Hashing.sha1().hashBytes(this.getValue().getBytes()).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<License ref:").append(this.getId()).append(", text:").append(this.getValue()).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License)obj;
        return Objects.equal((Object)this.getValue(), (Object)other.getValue()) && Objects.equal((Object)this.getId(), (Object)other.getId());
    }

    public boolean checkAccepted(File repositoryRoot, FileOp fop) {
        if (repositoryRoot == null) {
            return false;
        }
        File licenseDir = new File(repositoryRoot, LICENSE_DIR);
        File licenseFile = new File(licenseDir, this.getId() == null ? this.getLicenseHash() : this.getId());
        if (!fop.exists(licenseFile)) {
            return false;
        }
        try {
            for (String hash : CharStreams.readLines((Readable)new InputStreamReader(fop.newFileInputStream(licenseFile)))) {
                if (!hash.equals(this.getLicenseHash())) continue;
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public boolean setAccepted(File repositoryRoot, FileOp fop) {
        if (repositoryRoot == null) {
            return false;
        }
        if (this.checkAccepted(repositoryRoot, fop)) {
            return true;
        }
        File licenseDir = new File(repositoryRoot, LICENSE_DIR);
        if (fop.exists(licenseDir) && !fop.isDirectory(licenseDir)) {
            return false;
        }
        if (!fop.exists(licenseDir) && !fop.mkdirs(licenseDir)) {
            return false;
        }
        File licenseFile = new File(licenseDir, this.getId() == null ? this.getLicenseHash() : this.getId());
        try (OutputStream os = fop.newFileOutputStream(licenseFile, true);){
            os.write(String.format("%n%s", this.getLicenseHash()).getBytes());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

