/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataBindingItem
implements Iterable<DataBindingItem> {
    private final ResourceReference mReference;
    private final int mCount;
    private List<DataBindingItem> mChildren;

    public DataBindingItem(ResourceReference reference, int count) {
        this.mReference = reference;
        this.mCount = count;
    }

    public DataBindingItem(String name, boolean platformLayout, int count) {
        this(new ResourceReference(name, platformLayout), count);
    }

    public DataBindingItem(String name, boolean platformLayout) {
        this(name, platformLayout, 1);
    }

    public DataBindingItem(String name, int count) {
        this(name, false, count);
    }

    public DataBindingItem(String name) {
        this(name, false, 1);
    }

    public ResourceReference getViewReference() {
        return this.mReference;
    }

    public int getCount() {
        return this.mCount;
    }

    public void addChild(DataBindingItem child) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<DataBindingItem>();
        }
        this.mChildren.add(child);
    }

    public List<DataBindingItem> getChildren() {
        if (this.mChildren != null) {
            return this.mChildren;
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<DataBindingItem> iterator() {
        List<DataBindingItem> list = this.getChildren();
        return list.iterator();
    }
}

