/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.ApkVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import org.gradle.internal.reflect.Instantiator;

public class ApiObjectFactory {
    private final AndroidBuilder androidBuilder;
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final Instantiator instantiator;
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(AndroidBuilder androidBuilder, BaseExtension extension, VariantFactory variantFactory, Instantiator instantiator) {
        this.androidBuilder = androidBuilder;
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.instantiator = instantiator;
    }

    public void create(BaseVariantData<?> variantData) {
        if (variantData.getType().isForTesting()) {
            return;
        }
        BaseVariant variantApi = this.variantFactory.createVariantApi(variantData, this.readOnlyObjectProvider);
        if (this.variantFactory.hasTestScope()) {
            TestVariantData unitTestVariantData;
            TestVariantData androidTestVariantData = ((TestedVariantData)variantData).getTestVariantData(VariantType.ANDROID_TEST);
            if (androidTestVariantData != null) {
                TestVariantImpl androidTestVariant = (TestVariantImpl)this.instantiator.newInstance(TestVariantImpl.class, new Object[]{androidTestVariantData, variantApi, this.androidBuilder, this.readOnlyObjectProvider});
                ApplicationVariantFactory.createApkOutputApiObjects((Instantiator)this.instantiator, (BaseVariantData)androidTestVariantData, (ApkVariantImpl)androidTestVariant);
                ((TestedAndroidConfig)this.extension).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)variantApi).setTestVariant((TestVariant)androidTestVariant);
            }
            if ((unitTestVariantData = ((TestedVariantData)variantData).getTestVariantData(VariantType.UNIT_TEST)) != null) {
                UnitTestVariantImpl unitTestVariant = (UnitTestVariantImpl)this.instantiator.newInstance(UnitTestVariantImpl.class, new Object[]{unitTestVariantData, variantApi, this.androidBuilder, this.readOnlyObjectProvider});
                ((TestedAndroidConfig)this.extension).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)variantApi).setUnitTestVariant((UnitTestVariant)unitTestVariant);
            }
        }
        this.extension.addVariant(variantApi);
    }
}

