/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class NativeTargetingValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        module.getNativeConfig().ifPresent(targeting -> NativeTargetingValidator.validateTargeting(module, targeting));
    }

    private static void validateTargeting(BundleModule module, Files.NativeLibraries nativeLibraries) {
        if (nativeLibraries.getDirectoryGroupCount() > 1) {
            throw new ValidationException("Native libraries targeting supports at most one directory group, found %d.", nativeLibraries.getDirectoryGroupCount());
        }
        ArrayList<String> targetedDirs = new ArrayList<String>();
        for (Files.NativeDirectoryGroup directoryGroup : nativeLibraries.getDirectoryGroupList()) {
            for (Files.TargetedNativeDirectory targetedDirectory : directoryGroup.getTargetedDirectoryList()) {
                Path path = Paths.get(targetedDirectory.getPath(), new String[0]);
                Targeting.NativeDirectoryTargeting targeting = targetedDirectory.getTargeting();
                if (!targeting.hasAbi()) {
                    throw new ValidationException("Targeted native directory '%s' does not have the ABI dimension set.", targetedDirectory.getPath());
                }
                if (!path.startsWith(BundleModule.LIB_DIRECTORY) || path.getNameCount() != 2) {
                    throw new ValidationException("Path of targeted native directory must be in format 'lib/<directory>', found '%s'.", path);
                }
                if (BundleValidationUtils.directoryContainsNoFiles(module, path)) {
                    throw new ValidationException("Targeted directory '%s' is empty.", path);
                }
                targetedDirs.add(path.toString());
            }
        }
        BundleValidationUtils.checkNonOverlappingPathsAcrossDirectoryGroups(targetedDirs);
    }
}

