/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;

public class BundleValidationUtils {
    public static boolean directoryContainsNoFiles(BundleModule module, Path dir) {
        return module.findEntriesUnderPath(dir).count() == 0L;
    }

    public static void checkNonOverlappingPathsAcrossDirectoryGroups(Collection<String> targetedDirectories) {
        HashSet<String> used = new HashSet<String>();
        for (String path : targetedDirectories) {
            if (used.add(path)) continue;
            throw new ValidationException("Path '%s' is used in multiple directory groups.", path);
        }
    }

    private BundleValidationUtils() {
    }
}

