/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.zip;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class OutputBuilder {
    protected final Map<String, InputStreamSupplier> entries = new LinkedHashMap<String, InputStreamSupplier>();

    public abstract Path writeTo(Path var1) throws IOException;

    public OutputBuilder addFileWithContent(String toPath, byte[] content) {
        return this.addFile(toPath, () -> new ByteArrayInputStream(content));
    }

    public OutputBuilder addFileFromDisk(String toPath, Path file) {
        Preconditions.checkArgument((boolean)Files.isRegularFile(file, new LinkOption[0]), (String)"Path '%s' does not denote a file.", (Object)file);
        return this.addFile(toPath, () -> new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
    }

    public OutputBuilder addFileWithProtoContent(String toPath, MessageLite protoMsg) {
        return this.addFile(toPath, () -> new ByteArrayInputStream(protoMsg.toByteArray()));
    }

    public OutputBuilder addFileFromZip(String toPath, ZipFile fromZipFile, ZipEntry zipEntry) {
        return this.addFile(toPath, () -> fromZipFile.getInputStream(zipEntry));
    }

    private OutputBuilder addFile(String toPath, InputStreamSupplier inputStreamSupplier) {
        Preconditions.checkArgument((!toPath.endsWith("/") ? 1 : 0) != 0, (String)"File name cannot end with '/', got '%s'.", (Object)toPath);
        Preconditions.checkArgument((!this.entries.containsKey(toPath) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)toPath);
        Preconditions.checkArgument((!this.entries.containsKey(toPath + "/") ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)toPath);
        this.entries.put(toPath, inputStreamSupplier);
        return this;
    }

    public OutputBuilder addDirectory(String dir) {
        Preconditions.checkArgument((boolean)dir.endsWith("/"), (String)"The directory name should end with '/', got '%s'.", (Object)dir);
        String dirWithoutSlash = dir.substring(0, dir.length() - 1);
        Preconditions.checkArgument((!this.entries.containsKey(dir) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)dir);
        Preconditions.checkArgument((!this.entries.containsKey(dirWithoutSlash) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)dir);
        this.entries.put(dir, () -> new ByteArrayInputStream(new byte[0]));
        return this;
    }

    public OutputBuilder copyAllContentsFromZip(ZipFile srcZipFile, String toDirectory) {
        Preconditions.checkArgument((toDirectory.isEmpty() || toDirectory.endsWith("/") ? 1 : 0) != 0, (String)"The directory name has to be empty or end with '/', got '%s'.", (Object)toDirectory);
        Enumeration<? extends ZipEntry> zipEntries = srcZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.addFileFromZip(toDirectory + zipEntry.getName(), srcZipFile, zipEntry);
        }
        return this;
    }

    protected static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

