/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.Resources;
import com.google.common.base.Preconditions;
import java.util.Comparator;

public class ScreenDensityComparator
implements Comparator<Resources.ConfigValue> {
    private final int desiredDpi;

    public ScreenDensityComparator(int desiredDpi) {
        this.desiredDpi = desiredDpi == 0 || desiredDpi == 65534 ? 160 : desiredDpi;
    }

    @Override
    public int compare(Resources.ConfigValue value1, Resources.ConfigValue value2) {
        int value2Density;
        int value1Density = ScreenDensityComparator.getDpiValue(value1);
        if (value1Density == (value2Density = ScreenDensityComparator.getDpiValue(value2))) {
            return 0;
        }
        if (value1Density == 65534) {
            return 1;
        }
        if (value2Density == 65534) {
            return -1;
        }
        if (value1Density > value2Density) {
            return -1 * this.compareScaling(value2Density, value1Density);
        }
        return this.compareScaling(value1Density, value2Density);
    }

    private int compareScaling(int lowerDpi, int higherDpi) {
        Preconditions.checkArgument((lowerDpi <= higherDpi ? 1 : 0) != 0, (Object)"Calling compareScaling() requires arg1 <= arg2.");
        if (this.desiredDpi >= higherDpi) {
            return -1;
        }
        if (this.desiredDpi <= lowerDpi) {
            return 1;
        }
        if ((2 * lowerDpi - this.desiredDpi) * higherDpi > this.desiredDpi * this.desiredDpi) {
            return 1;
        }
        return -1;
    }

    private static int getDpiValue(Resources.ConfigValue configValue) {
        if (configValue.getConfig().getDensity() == 0) {
            return 160;
        }
        return configValue.getConfig().getDensity();
    }
}

