/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.ManifestEditor;
import com.android.tools.build.bundletool.manifest.ProtoManifest;
import com.android.tools.build.bundletool.manifest.ProtoXmlHelper;
import com.google.common.base.Preconditions;

public class ProtoManifestEditor
implements ManifestEditor {
    private final Resources.XmlNode.Builder rootNodeBuilder;

    public ProtoManifestEditor(Resources.XmlNode rootNode) {
        this.rootNodeBuilder = rootNode.toBuilder();
    }

    @Override
    public ManifestEditor setSplitIdForFeatureSplit(String splitId) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        if (ProtoManifestEditor.isBaseSplit(splitId)) {
            ProtoXmlHelper.removeAttribute(manifestBuilder, "", "split");
        } else {
            Resources.XmlAttribute.Builder splitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "split");
            splitAttributeBuilder.setValue(splitId);
        }
        ProtoXmlHelper.removeAttribute(manifestBuilder, "", "configForSplit");
        Resources.XmlAttribute.Builder isFeatureSplitAttribute = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "http://schemas.android.com/apk/res/android", "isFeatureSplit");
        ProtoXmlHelper.setAttributeValueAsBoolean(isFeatureSplitAttribute, true);
        return this;
    }

    @Override
    public ManifestEditor setSplitIdForConfigSplit(String splitId, String featureSplitId) {
        Preconditions.checkArgument((!splitId.isEmpty() ? 1 : 0) != 0, (Object)"SplitId cannot be empty for config split!");
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        ProtoXmlHelper.removeAttribute(manifestBuilder, "", "dynamic");
        Resources.XmlAttribute.Builder splitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "split");
        splitAttributeBuilder.setValue(splitId);
        ProtoXmlHelper.removeAttribute(manifestBuilder, "http://schemas.android.com/apk/res/android", "isFeatureSplit");
        if (!featureSplitId.isEmpty()) {
            Resources.XmlAttribute.Builder featureSplitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "configForSplit");
            featureSplitAttributeBuilder.setValue(featureSplitId);
        }
        Resources.XmlElement.Builder applicationBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "application");
        Resources.XmlAttribute.Builder hasCodeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(applicationBuilder, "http://schemas.android.com/apk/res/android", "hasCode");
        hasCodeBuilder.setResourceId(0x101000C);
        ProtoXmlHelper.setAttributeValueAsBoolean(hasCodeBuilder, false);
        return this;
    }

    private static boolean isBaseSplit(String splitId) {
        return splitId.isEmpty();
    }

    @Override
    public AndroidManifest save() {
        return ProtoManifest.create(this.rootNodeBuilder.build());
    }
}

